/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.io.Closeable;
import java.io.IOException;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.threads.CancellableTimer;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.threads.VanillaEventHandler;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CancellableTimerTest
extends CoreTestCommon {
    public static final int INITIAL_DELAY_MS = 1000;
    public static final int PERIOD_MS = 2000;
    @Mock
    private EventLoop eventLoop;
    @Mock
    private VanillaEventHandler handler;
    @Mock
    private Runnable runnable;
    private CancellableTimer.ScheduledEventHandler scheduledEventHandler;
    private CancellableTimer timer;
    private SetTimeProvider timeProvider;

    CancellableTimerTest() {
    }

    @BeforeEach
    void setUp() {
        this.timeProvider = new SetTimeProvider();
        ((EventLoop)Mockito.doAnswer(iom -> {
            this.scheduledEventHandler = (CancellableTimer.ScheduledEventHandler)iom.getArgument(0);
            return null;
        }).when((Object)this.eventLoop)).addHandler((EventHandler)Mockito.any(EventHandler.class));
        this.timer = new CancellableTimer(this.eventLoop, (TimeProvider)this.timeProvider);
    }

    @Test
    void willExecuteScheduledTaskPeriodically() throws InvalidEventHandlerException {
        long submittedTime = System.currentTimeMillis();
        this.timeProvider.currentTimeMillis(submittedTime);
        this.timer.scheduleAtFixedRate(this.handler, 1000L, 2000L);
        this.scheduledEventHandler.action();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.handler});
        long firstCallTime = submittedTime + 1000L + 1L;
        this.timeProvider.currentTimeMillis(firstCallTime);
        this.scheduledEventHandler.action();
        ((VanillaEventHandler)Mockito.verify((Object)this.handler)).action();
        Mockito.reset((Object[])new VanillaEventHandler[]{this.handler});
        this.timeProvider.currentTimeMillis(firstCallTime + 2000L - 10L);
        this.scheduledEventHandler.action();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.handler});
        this.timeProvider.currentTimeMillis(firstCallTime + 2000L + 10L);
        this.scheduledEventHandler.action();
        ((VanillaEventHandler)Mockito.verify((Object)this.handler)).action();
    }

    @Test
    void willSubmitHandlerWithConfiguredPriority() {
        HandlerPriority configuredPriority = HandlerPriority.REPLICATION_TIMER;
        this.timer.scheduleAtFixedRate(this.handler, 1000L, 2000L, configuredPriority);
        Assertions.assertEquals((Object)configuredPriority, (Object)this.scheduledEventHandler.priority());
    }

    @Test
    void willSubmitHandlerWithTimerPriorityByDefault() {
        this.timer.scheduleAtFixedRate(this.handler, 1000L, 2000L);
        Assertions.assertEquals((Object)HandlerPriority.TIMER, (Object)this.scheduledEventHandler.priority());
    }

    @Test
    void willThrowInvalidEventHandlerWhenCloseIsCalled() throws InvalidEventHandlerException, IOException {
        Closeable closeable = this.timer.scheduleAtFixedRate(this.handler, 1000L, 2000L);
        this.scheduledEventHandler.action();
        closeable.close();
        Assertions.assertThrows(InvalidEventHandlerException.class, () -> this.scheduledEventHandler.action());
    }

    @Test
    void willScheduleSingleExecutionTask() throws InvalidEventHandlerException {
        long submittedTime = System.currentTimeMillis();
        this.timeProvider.currentTimeMillis(submittedTime);
        this.timer.schedule(this.runnable, 1000L);
        this.scheduledEventHandler.action();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.handler});
        long firstCallTime = submittedTime + 1000L + 1L;
        this.timeProvider.currentTimeMillis(firstCallTime);
        Assertions.assertThrows(InvalidEventHandlerException.class, () -> this.scheduledEventHandler.action());
        ((Runnable)Mockito.verify((Object)this.runnable)).run();
    }

    @Test
    void canCancelSingleExecutionTask() throws InvalidEventHandlerException, IOException {
        long submittedTime = System.currentTimeMillis();
        this.timeProvider.currentTimeMillis(submittedTime);
        Closeable closeable = this.timer.schedule(this.runnable, 1000L);
        this.scheduledEventHandler.action();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.handler});
        closeable.close();
        long firstCallTime = submittedTime + 1000L + 1L;
        this.timeProvider.currentTimeMillis(firstCallTime);
        Assertions.assertThrows(InvalidEventHandlerException.class, () -> this.scheduledEventHandler.action());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.runnable});
    }
}

