/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.BitSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class CleaningThreadTest
extends CoreTestCommon {
    @Test
    public void cleanupThreadLocal() throws InterruptedException {
        String threadName = "ctl-test";
        LinkedBlockingQueue ints = new LinkedBlockingQueue();
        CleaningThreadLocal counter = CleaningThreadLocal.withCleanup(() -> Thread.currentThread().getName(), ints::add);
        CleaningThread ct = new CleaningThread(() -> Assert.assertEquals((Object)threadName, (Object)counter.get()), threadName);
        ct.start();
        String poll = (String)ints.poll(1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)threadName, (Object)poll);
    }

    @Test
    public void testRemove() {
        int[] counter = new int[]{0};
        CleaningThreadLocal ctl = CleaningThreadLocal.withCloseQuietly(() -> {
            int n = counter[0];
            counter[0] = n + 1;
            return n;
        });
        Assert.assertEquals((long)0L, (long)((Integer)ctl.get()).intValue());
        CleaningThread.performCleanup((Thread)Thread.currentThread());
        Assert.assertEquals((long)1L, (long)((Integer)ctl.get()).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetThreadAffinity() throws InterruptedException {
        BitSet affinity = Affinity.getAffinity();
        Assume.assumeTrue((affinity.cardinality() > 2 ? 1 : 0) != 0);
        Assume.assumeTrue((AffinityLock.BASE_AFFINITY.cardinality() > 2 ? 1 : 0) != 0);
        try {
            Affinity.setAffinity((int)1);
            BitSet[] nestedAffinity = new BitSet[]{null};
            CleaningThread ct = new CleaningThread(() -> {
                nestedAffinity[0] = Affinity.getAffinity();
            });
            ct.start();
            ct.join();
            Assert.assertEquals((Object)AffinityLock.BASE_AFFINITY, (Object)nestedAffinity[0]);
        }
        finally {
            Affinity.setAffinity((BitSet)affinity);
        }
    }
}

