/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.JitterSampler;
import org.junit.Assert;
import org.junit.Test;

public class JitterSamplerTest
extends CoreTestCommon {
    @Test
    public void takeSnapshot() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(2);
        Thread t = new Thread(() -> {
            JitterSampler.atStage((String)"started");
            this.waitForLatch(latch);
            int millis = Jvm.isArm() ? 120 : 60;
            Jvm.pause((long)millis);
            JitterSampler.atStage((String)"finishing");
            Jvm.pause((long)millis);
            JitterSampler.finished();
        });
        t.start();
        this.waitForLatch(latch);
        for (int i = 0; i < 10; ++i) {
            Jvm.busyWaitMicros((long)1000L);
            String s = JitterSampler.takeSnapshot((long)10000000L);
            String desc = JitterSampler.desc;
            if ("finishing".equals(desc)) {
                if (s == null || !s.contains("finish")) continue;
                break;
            }
            Assert.assertEquals((Object)"started", (Object)desc);
        }
        t.join();
        String s = JitterSampler.takeSnapshot();
        Assert.assertNull((Object)s);
    }

    private void waitForLatch(CountDownLatch latch) {
        latch.countDown();
        try {
            Assert.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted waiting for latch", e);
        }
    }
}

