/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.Timer;
import net.openhft.chronicle.core.threads.VanillaEventHandler;
import net.openhft.chronicle.core.time.TimeProvider;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TimerTest {
    private Timer timer;
    private EventLoop eventLoop;
    private TimeProvider timeProvider;

    @BeforeEach
    public void setUp() {
        this.eventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        this.timeProvider = (TimeProvider)Mockito.mock(TimeProvider.class);
        this.timer = new Timer(this.eventLoop, this.timeProvider);
    }

    @Test
    public void testScheduleAtFixedRateWithEventHandler() {
        VanillaEventHandler eventHandler = (VanillaEventHandler)Mockito.mock(VanillaEventHandler.class);
        long initialDelayMs = 1000L;
        long periodMs = 500L;
        this.timer.scheduleAtFixedRate(eventHandler, initialDelayMs, periodMs);
    }

    @Test
    public void testScheduleAtFixedRateWithEventHandlerAndPriority() {
        VanillaEventHandler eventHandler = (VanillaEventHandler)Mockito.mock(VanillaEventHandler.class);
        long initialDelayMs = 1000L;
        long periodMs = 500L;
        HandlerPriority priority = HandlerPriority.MEDIUM;
        this.timer.scheduleAtFixedRate(eventHandler, initialDelayMs, periodMs, priority);
    }

    @Test
    public void testSchedule() {
        Runnable eventHandler = (Runnable)Mockito.mock(Runnable.class);
        long initialDelayMs = 1000L;
        this.timer.schedule(eventHandler, initialDelayMs);
    }
}

