/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.testframework.FlakyTestRunner;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class SystemTimeProviderTest
extends CoreTestCommon {
    @Test
    public void currentTimeMicros() throws IllegalStateException {
        for (int i = 0; i < 3; ++i) {
            try {
                FlakyTestRunner.builder(this::doCurrentTimeMicros).withFlakyOnThisArchitecture(Jvm.isArm() || OS.isWindows() || OS.isMacOSX()).build().run();
                break;
            }
            catch (Throwable t) {
                System.out.println("Trying to deflake flaky test: " + i);
                Jvm.pause((long)(500 + new SecureRandom().nextInt(500)));
                continue;
            }
        }
    }

    static void assertBetween(long min, long actual, long max) {
        if (min <= actual && actual <= max) {
            return;
        }
        throw new AssertionError((Object)("Not in range " + min + " <= " + actual + " <= " + max));
    }

    private void doCurrentTimeMicros() throws IllegalStateException {
        @NotNull SystemTimeProvider tp = SystemTimeProvider.INSTANCE;
        long minDiff = 0L;
        long maxDiff = 0L;
        int error = OS.isWindows() || Jvm.isArm() ? 12 : 1;
        for (int i = 0; i <= 20; ++i) {
            minDiff = 10L;
            maxDiff = 995L;
            long lastTimeMicros = 0L;
            long start = System.currentTimeMillis();
            do {
                long now0 = tp.currentTimeMillis();
                long time2 = tp.currentTimeMicros();
                long now1 = tp.currentTimeMillis();
                if (now1 - now0 > 1L) {
                    System.out.println("jump: " + (now1 - now0));
                    continue;
                }
                long now = now1 * 1000L;
                long diff = time2 - now;
                if (minDiff > diff) {
                    minDiff = diff;
                }
                if (maxDiff < diff) {
                    maxDiff = diff;
                }
                long ns = System.nanoTime();
                while (System.nanoTime() < ns + 100L) {
                    Jvm.nanoPause();
                }
                Assert.assertTrue((time2 >= lastTimeMicros ? 1 : 0) != 0);
                lastTimeMicros = time2;
            } while (System.currentTimeMillis() < start + 500L);
            try {
                SystemTimeProviderTest.assertBetween(-5 * error, minDiff, 5 * error);
                SystemTimeProviderTest.assertBetween(990L, maxDiff, 1000 + 30 * error);
                break;
            }
            catch (AssertionError e) {
                continue;
            }
        }
        SystemTimeProviderTest.assertBetween(-5 * error, minDiff, 5 * error);
        SystemTimeProviderTest.assertBetween(990L, maxDiff, 1000 + 30 * error);
    }

    @Test
    public void currentTime() throws IllegalStateException {
        for (int i = 3; i >= 0; --i) {
            SystemTimeProvider tp = SystemTimeProvider.INSTANCE;
            long time1 = tp.currentTime(TimeUnit.SECONDS);
            long time2 = tp.currentTimeMillis();
            long time3 = tp.currentTimeMicros();
            long time4 = tp.currentTimeNanos();
            try {
                SystemTimeProviderTest.assertBetween(time2 / 1000L, time1, time2 / 1000L + 2L);
                SystemTimeProviderTest.assertBetween(time3 / 1000L - 8L, time2, time3 / 1000L + 20L);
                SystemTimeProviderTest.assertBetween(time4 / 1000L - 100L, time3, time4 / 1000L + 2000L);
                continue;
            }
            catch (AssertionError ae) {
                Thread.yield();
                if (i != 0) continue;
                throw ae;
            }
        }
    }

    @Test
    public void resolution() {
        for (int j = 0; j < 3; ++j) {
            Histogram h = new Histogram(32, 10, 1.0);
            long last = SystemTimeProvider.INSTANCE.currentTimeNanos();
            for (int i = 0; i < 5000000; ++i) {
                long next = SystemTimeProvider.INSTANCE.currentTimeNanos();
                h.sampleNanos(next - last);
                Jvm.nanoPause();
                last = next;
            }
            System.out.println(h.toMicrosFormat());
            Assert.assertTrue((h.totalCount() > 0L ? 1 : 0) != 0);
        }
    }
}

