/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.time.UniqueMicroTimeProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UniqueMicroTimeProviderTest
extends CoreTestCommon {
    private UniqueMicroTimeProvider timeProvider;
    private SetTimeProvider setTimeProvider;

    @Before
    public void setUp() {
        this.timeProvider = new UniqueMicroTimeProvider();
        this.setTimeProvider = new SetTimeProvider(0L);
        this.timeProvider.provider((TimeProvider)this.setTimeProvider);
    }

    @Test
    public void shouldProvideUniqueTimeAcrossThreadsMillis() throws InterruptedException {
        ConcurrentHashMap.KeySetView allGeneratedTimestamps = ConcurrentHashMap.newKeySet();
        int numberOfThreads = 100;
        int iterationsPerThread = 100;
        ExecutorService executor = Executors.newFixedThreadPool(100);
        CountDownLatch latch = new CountDownLatch(100);
        for (int i = 0; i < 100; ++i) {
            executor.execute(() -> {
                try {
                    ArrayList<Long> threadTimeSet = new ArrayList<Long>(100);
                    long lastTimestamp = 0L;
                    for (int j = 0; j < 100; ++j) {
                        this.setTimeProvider.advanceMicros((long)(j * 100));
                        long currentTimeMillis = this.timeProvider.currentTimeMillis();
                        threadTimeSet.add(currentTimeMillis);
                        Assert.assertTrue((String)"Timestamps should always increase", (currentTimeMillis > lastTimestamp ? 1 : 0) != 0);
                        lastTimestamp = currentTimeMillis;
                    }
                    allGeneratedTimestamps.addAll(threadTimeSet);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
        executor.shutdown();
        Assert.assertEquals((String)"All timestamps across all threads and iterations should be unique", (long)10000L, (long)allGeneratedTimestamps.size());
    }

    @Test
    public void shouldProvideUniqueTimeAcrossThreadsMicros() throws InterruptedException {
        ConcurrentHashMap.KeySetView allGeneratedTimestamps = ConcurrentHashMap.newKeySet();
        int numberOfThreads = 50;
        int factor = 50;
        int iterationsPerThread = 1000;
        ExecutorService executor = Executors.newFixedThreadPool(50);
        CountDownLatch latch = new CountDownLatch(2500);
        for (int i = 0; i < 2500; ++i) {
            executor.execute(() -> {
                try {
                    ArrayList<Long> threadTimeSet = new ArrayList<Long>(1000);
                    long lastTimestamp = 0L;
                    for (int j = 0; j < 1000; ++j) {
                        this.setTimeProvider.advanceMicros((long)j);
                        long currentTimeMicros = this.timeProvider.currentTimeMicros();
                        threadTimeSet.add(currentTimeMicros);
                        Assert.assertTrue((String)"Timestamps should always increase", (currentTimeMicros > lastTimestamp ? 1 : 0) != 0);
                        lastTimestamp = currentTimeMicros;
                    }
                    allGeneratedTimestamps.addAll(threadTimeSet);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
        executor.shutdown();
        Assert.assertEquals((String)"All timestamps across all threads and iterations should be unique", (long)2500000L, (long)allGeneratedTimestamps.size());
    }

    @Test
    public void shouldProvideUniqueTimeAcrossThreadsNanos() throws InterruptedException {
        ConcurrentHashMap.KeySetView allGeneratedTimestamps = ConcurrentHashMap.newKeySet();
        int numberOfThreads = 50;
        int factor = 50;
        int iterationsPerThread = 500;
        ExecutorService executor = Executors.newFixedThreadPool(50);
        CountDownLatch latch = new CountDownLatch(2500);
        for (int i = 0; i < 2500; ++i) {
            executor.execute(() -> {
                try {
                    ArrayList<Long> threadTimeSet = new ArrayList<Long>(500);
                    long lastTimestamp = 0L;
                    for (int j = 0; j < 500; ++j) {
                        this.setTimeProvider.advanceNanos((long)j);
                        long currentTimeNanos = this.timeProvider.currentTimeNanos();
                        threadTimeSet.add(currentTimeNanos);
                        Assert.assertTrue((String)"Timestamps should always be in the next micros", (currentTimeNanos / 1000L > lastTimestamp / 1000L ? 1 : 0) != 0);
                        lastTimestamp = currentTimeNanos;
                    }
                    allGeneratedTimestamps.addAll(threadTimeSet);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
        executor.shutdown();
        Assert.assertEquals((String)"All timestamps across all threads and iterations should be unique", (long)1250000L, (long)allGeneratedTimestamps.size());
    }

    @Test
    public void shouldAdvanceTimeWhenExceedingCallsPerSecond() {
        int iterations = 1000001;
        long lastTimeMicros = 0L;
        for (int i = 0; i < 1000001; ++i) {
            this.setTimeProvider.advanceNanos((long)i);
            long currentTimeMicros = this.timeProvider.currentTimeMicros();
            Assert.assertTrue((String)"Each timestamp must be greater than the last", (currentTimeMicros > lastTimeMicros ? 1 : 0) != 0);
            lastTimeMicros = currentTimeMicros;
        }
    }

    @Test
    public void currentTimeMillisShouldBeCorrect() {
        int iterations = 1000;
        long lastTimeMillis = 0L;
        long startTimeMillis = this.setTimeProvider.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            this.setTimeProvider.advanceNanos((long)i);
            long currentTimeMillis = this.timeProvider.currentTimeMillis();
            Assert.assertTrue((currentTimeMillis >= startTimeMillis ? 1 : 0) != 0);
            Assert.assertTrue((currentTimeMillis <= startTimeMillis + (long)iterations ? 1 : 0) != 0);
            Assert.assertTrue((String)"Millisecond timestamps must increase", (currentTimeMillis > lastTimeMillis ? 1 : 0) != 0);
            lastTimeMillis = currentTimeMillis;
        }
    }

    @Test
    public void currentTimeMicrosShouldBeCorrect() {
        long lastTimeMicros = 0L;
        for (int i = 0; i < 4000; ++i) {
            this.setTimeProvider.advanceNanos((long)i);
            long currentTimeMicros = this.timeProvider.currentTimeMicros();
            Assert.assertTrue((String)"Microsecond timestamps must increase", (currentTimeMicros > lastTimeMicros ? 1 : 0) != 0);
            lastTimeMicros = currentTimeMicros;
        }
    }

    @Test
    public void currentTimeMicrosShouldBeCorrectBackwards() {
        long lastTimeMicros = 0L;
        for (int i = 0; i < 4000; ++i) {
            this.setTimeProvider.advanceNanos((long)(-i));
            long currentTimeMicros = this.timeProvider.currentTimeMicros();
            Assert.assertTrue((String)"Microsecond timestamps must increase", (currentTimeMicros > lastTimeMicros ? 1 : 0) != 0);
            lastTimeMicros = currentTimeMicros;
        }
    }

    @Test
    public void currentTimeNanosShouldBeCorrect() {
        long lastTimeMicros = 0L;
        for (int i = 0; i < 4000; ++i) {
            this.setTimeProvider.advanceNanos((long)i);
            long currentTimeNanos = this.timeProvider.currentTimeNanos();
            Assert.assertTrue((String)"Nanosecond timestamps adjusted to microsecond level should increase", (currentTimeNanos / 1000L > lastTimeMicros ? 1 : 0) != 0);
            lastTimeMicros = currentTimeNanos / 1000L;
        }
    }
}

