/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.AbstractInvocationHandler;
import net.openhft.chronicle.core.util.ConcreteInvocationHandler;
import net.openhft.chronicle.core.util.Mocker;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractInvocationHandlerTest
extends CoreTestCommon {
    private AbstractInvocationHandler handler;
    private Method exampleMethod;

    @BeforeEach
    public void setUp() throws NoSuchMethodException {
        this.handler = new ConcreteInvocationHandler();
        this.exampleMethod = String.class.getMethod("length", new Class[0]);
    }

    @Test
    public void testCloseable() throws Throwable {
        ConcreteInvocationHandler handler = new ConcreteInvocationHandler();
        Closeable mockCloseable = (Closeable)Mockito.mock(Closeable.class);
        handler.onClose(mockCloseable);
        Method closeMethod = Closeable.class.getMethod("close", new Class[0]);
        handler.invoke(mockCloseable, closeMethod, null);
        ((Closeable)Mockito.verify((Object)mockCloseable, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testMethodHandleForProxy() throws Throwable {
        Assume.assumeTrue((Jvm.majorVersion() >= 17 ? 1 : 0) != 0);
        ConcreteInvocationHandler handler = new ConcreteInvocationHandler();
        Method exampleMethod = String.class.getMethod("length", new Class[0]);
        Assert.assertNotNull((Object)handler.methodHandleForProxy("example", exampleMethod));
    }

    @Test
    public void testInvoke() {
        ArrayList messages = new ArrayList();
        Consumer<String> consumer = s -> messages.add(s);
        CallMe mocked = (CallMe)Mocker.intercepting(CallMe.class, (String)"", consumer);
        mocked.method1();
        mocked.method2();
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)"method1[]", messages.get(0));
        Assert.assertEquals((Object)"method2[]", messages.get(1));
    }

    @FunctionalInterface
    public static interface CallMe {
        public void method1();

        default public void method2() {
            throw new AssertionError((Object)"Don't call me");
        }
    }
}

