/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import net.openhft.chronicle.core.util.ByteConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ByteConsumerTest {
    ByteConsumerTest() {
    }

    @Test
    void acceptShouldPerformOperation() {
        byte[] resultContainer = new byte[1];
        ByteConsumer consumer = value -> {
            resultContainer[0] = value;
        };
        consumer.accept((byte)10);
        Assertions.assertEquals((byte)10, (byte)resultContainer[0]);
    }

    @Test
    void andThenShouldPerformBothOperationsInSequence() {
        byte[] resultContainer = new byte[2];
        ByteConsumer firstConsumer = value -> {
            resultContainer[0] = value;
        };
        ByteConsumer secondConsumer = value -> {
            resultContainer[1] = (byte)(value + 10);
        };
        ByteConsumer combinedConsumer = firstConsumer.andThen(secondConsumer);
        combinedConsumer.accept((byte)5);
        Assertions.assertEquals((byte)5, (byte)resultContainer[0]);
        Assertions.assertEquals((byte)15, (byte)resultContainer[1]);
    }

    @Test
    void andThenShouldThrowNullPointerExceptionIfAfterIsNull() {
        ByteConsumer consumer = value -> {};
        Assertions.assertThrows(NullPointerException.class, () -> consumer.andThen(null));
    }

    @Test
    void andThenShouldNotPerformSecondOperationIfFirstThrowsException() {
        ByteConsumer firstConsumer = value -> {
            throw new RuntimeException();
        };
        ByteConsumer secondConsumer = (ByteConsumer)Mockito.mock(ByteConsumer.class);
        ByteConsumer combinedConsumer = firstConsumer.andThen(secondConsumer);
        Assertions.assertThrows(RuntimeException.class, () -> combinedConsumer.accept((byte)5));
        ((ByteConsumer)Mockito.verify((Object)secondConsumer, (VerificationMode)Mockito.never())).accept(ArgumentMatchers.anyByte());
    }
}

