/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import net.openhft.chronicle.core.util.CharSequenceComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CharSequenceComparatorTest {
    CharSequenceComparatorTest() {
    }

    @Test
    void compareIdenticalSequences() {
        String seq1 = "test";
        String seq2 = "test";
        Assertions.assertEquals((int)0, (int)CharSequenceComparator.INSTANCE.compare((CharSequence)seq1, (CharSequence)seq2));
    }

    @Test
    void compareDifferentSequencesSameLength() {
        String seq1 = "abc";
        String seq2 = "abd";
        Assertions.assertTrue((CharSequenceComparator.INSTANCE.compare((CharSequence)seq1, (CharSequence)seq2) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((CharSequenceComparator.INSTANCE.compare((CharSequence)seq2, (CharSequence)seq1) > 0 ? 1 : 0) != 0);
    }

    @Test
    void compareDifferentLengthSequences() {
        String seq1 = "abc";
        String seq2 = "abcd";
        Assertions.assertTrue((CharSequenceComparator.INSTANCE.compare((CharSequence)seq1, (CharSequence)seq2) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((CharSequenceComparator.INSTANCE.compare((CharSequence)seq2, (CharSequence)seq1) > 0 ? 1 : 0) != 0);
    }

    @Test
    void compareEmptyAndNonEmptySequences() {
        String emptySeq = "";
        String nonEmptySeq = "test";
        Assertions.assertTrue((CharSequenceComparator.INSTANCE.compare((CharSequence)emptySeq, (CharSequence)nonEmptySeq) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((CharSequenceComparator.INSTANCE.compare((CharSequence)nonEmptySeq, (CharSequence)emptySeq) > 0 ? 1 : 0) != 0);
    }
}

