/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import net.openhft.chronicle.core.util.IntBiPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IntBiPredicateTest {
    IntBiPredicateTest() {
    }

    @Test
    void testShouldReturnCorrectResult() {
        IntBiPredicate predicate = (t, u) -> t > u;
        Assertions.assertTrue((boolean)predicate.test(2, 1));
        Assertions.assertFalse((boolean)predicate.test(1, 2));
    }

    @Test
    void andShouldCombineTwoPredicates() {
        IntBiPredicate predicate1 = (t, u) -> t > u;
        IntBiPredicate predicate2 = (t, u) -> t % 2 == 0;
        IntBiPredicate combined = predicate1.and(predicate2);
        Assertions.assertTrue((boolean)combined.test(4, 3));
        Assertions.assertFalse((boolean)combined.test(1, 0));
    }

    @Test
    void negateShouldInvertPredicate() {
        IntBiPredicate predicate = (t, u) -> t > u;
        IntBiPredicate negated = predicate.negate();
        Assertions.assertFalse((boolean)negated.test(2, 1));
        Assertions.assertTrue((boolean)negated.test(1, 2));
    }

    @Test
    void orShouldCombineTwoPredicates() {
        IntBiPredicate predicate1 = (t, u) -> t > u;
        IntBiPredicate predicate2 = (t, u) -> u > 3;
        IntBiPredicate combined = predicate1.or(predicate2);
        Assertions.assertTrue((boolean)combined.test(1, 4));
        Assertions.assertFalse((boolean)combined.test(2, 2));
    }
}

