/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.function.Supplier;
import net.openhft.chronicle.core.util.ThrowingSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ThrowingSupplierTest {
    ThrowingSupplierTest() {
    }

    @Test
    void getShouldReturnResultWhenNoException() throws Exception {
        ThrowingSupplier throwingSupplier = () -> "test";
        Assertions.assertEquals((Object)"test", (Object)throwingSupplier.get());
    }

    @Test
    void getShouldThrowException() {
        ThrowingSupplier throwingSupplier = () -> {
            throw new Exception("error");
        };
        Exception exception = (Exception)Assertions.assertThrows(Exception.class, () -> ((ThrowingSupplier)throwingSupplier).get());
        Assertions.assertEquals((Object)"error", (Object)exception.getMessage());
    }

    @Test
    void asSupplierShouldReturnResultWhenNoException() {
        ThrowingSupplier throwingSupplier = () -> "test";
        Supplier supplier = ThrowingSupplier.asSupplier((ThrowingSupplier)throwingSupplier);
        Assertions.assertEquals((Object)"test", supplier.get());
    }
}

