/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.watcher;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.core.watcher.FileSystemWatcher;
import net.openhft.chronicle.core.watcher.WatcherListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class FileSystemWatcherTest
extends CoreTestCommon {
    static String base = OS.getTarget() + "/FileSystemWatcherTest-" + Time.uniqueId();

    @Before
    public void setup() throws IOException {
        this.tearDown();
        Files.createDirectories(Paths.get(base, new String[0]), new FileAttribute[0]);
    }

    @After
    public void tearDown() {
        IOTools.deleteDirWithFiles((String[])new String[]{base});
    }

    @Test
    public void bootstrapAndUpdate() throws IOException {
        Assume.assumeFalse((boolean)Jvm.isArm());
        Assume.assumeTrue((boolean)OS.isLinux());
        final ConcurrentSkipListMap<String, String> events = new ConcurrentSkipListMap<String, String>();
        WatcherListener listener = new WatcherListener(){

            public void onExists(String base, String filename, Boolean modified) {
                events.put(filename, "modified: " + modified);
            }

            public void onRemoved(String base, String filename) {
                events.put(filename, "removed: true");
            }
        };
        Assert.assertTrue((boolean)new File(base + "/dir1").mkdir());
        Assert.assertTrue((boolean)new File(base + "/dir2").mkdir());
        Assert.assertTrue((boolean)new File(base + "/dir1/file11").createNewFile());
        Assert.assertTrue((boolean)new File(base + "/dir1/file12").createNewFile());
        Assert.assertTrue((boolean)new File(base + "/dir2/file20").createNewFile());
        FileSystemWatcher watcher = new FileSystemWatcher();
        watcher.addPath(base);
        watcher.start();
        watcher.addListener(listener);
        this.retryAssertEquals("dir1=modified: null\ndir1/file11=modified: null\ndir1/file12=modified: null\ndir2=modified: null\ndir2/file20=modified: null", events);
        FileWriter fw = new FileWriter(base + "/dir1/file11");
        Throwable throwable = null;
        if (fw != null) {
            if (throwable != null) {
                try {
                    fw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                fw.close();
            }
        }
        Assert.assertTrue((boolean)new File(base + "/dir2/file20").delete());
        Assert.assertTrue((boolean)new File(base + "/dir2/file21").createNewFile());
        Assert.assertTrue((boolean)new File(base + "/dir3/dir30").mkdirs());
        Assert.assertTrue((boolean)new File(base + "/dir3/dir30/file301").createNewFile());
        this.retryAssertEquals("dir1=modified: null\ndir1/file11=modified: true\ndir1/file12=modified: null\ndir2=modified: null\ndir2/file20=removed: true\ndir2/file21=modified: false\ndir3=modified: false\ndir3/dir30=modified: null\ndir3/dir30/file301=modified: null", events);
        IOTools.deleteDirWithFiles((String)(base + "/dir2"), (int)2);
        this.retryAssertEquals("dir1=modified: null\ndir1/file11=modified: true\ndir1/file12=modified: null\ndir2=removed: true\ndir2/file20=removed: true\ndir2/file21=removed: true\ndir3=modified: false\ndir3/dir30=modified: null\ndir3/dir30/file301=modified: null", events);
        watcher.stop();
    }

    private void retryAssertEquals(String expected, SortedMap<String, String> events) {
        int i = Jvm.isDebug() ? 500 : 100;
        while (true) {
            try {
                Jvm.pause((long)20L);
                Assert.assertEquals((Object)expected, (Object)events.entrySet().stream().map(Object::toString).collect(Collectors.joining("\n")));
            }
            catch (AssertionError ae) {
                if (i <= 0) {
                    throw ae;
                }
                --i;
                continue;
            }
            break;
        }
    }
}

