/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.openhft.chronicle.core.internal.Bootstrap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtil {
    public static final MethodHandle setAccessible0_Method = ClassUtil.getSetAccessible0Method();

    private ClassUtil() {
    }

    private static MethodHandle getSetAccessible0Method() {
        if (!Bootstrap.isJava9Plus()) {
            return null;
        }
        MethodType signature = MethodType.methodType(Boolean.TYPE, Boolean.TYPE);
        try {
            Method privateLookupIn = MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)privateLookupIn.invoke(null, AccessibleObject.class, MethodHandles.lookup());
            return lookup.findVirtual(AccessibleObject.class, "setAccessible0", signature);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            Logger logger = LoggerFactory.getLogger(ClassUtil.class);
            logger.error("Chronicle products require command line arguments to be provided for Java 11 and above. See https://chronicle.software/chronicle-support-java-17");
            throw new ExceptionInInitializerError(e);
        }
    }

    public static Field getField0(@NotNull Class<?> clazz, @NotNull String name, boolean error) {
        try {
            Field field = clazz.getDeclaredField(name);
            ClassUtil.setAccessible(field);
            return field;
        }
        catch (NoSuchFieldException e) {
            Field field;
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && (field = ClassUtil.getField0(superclass, name, false)) != null) {
                return field;
            }
            if (error) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    public static void setAccessible(@NotNull AccessibleObject accessibleObject) {
        block4: {
            if (Bootstrap.isJava9Plus()) {
                try {
                    boolean newFlag = setAccessible0_Method.invokeExact(accessibleObject, true);
                    assert (newFlag);
                    break block4;
                }
                catch (Throwable throwable) {
                    throw new AssertionError((Object)throwable);
                }
            }
            accessibleObject.setAccessible(true);
        }
    }

    public static Method getMethod0(@NotNull Class<?> clazz, @NotNull String name, Class[] args, boolean first) {
        try {
            Method method = clazz.getDeclaredMethod(name, args);
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                ClassUtil.setAccessible(method);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    Method m = ClassUtil.getMethod0(superclass, name, args, false);
                    if (m != null) {
                        return m;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (first) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }
}

