/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import net.openhft.chronicle.core.internal.JvmExceptionTracker;
import net.openhft.chronicle.core.internal.ReferenceCountedUtils;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.testframework.exception.ExceptionTracker;
import org.junit.After;
import org.junit.Before;

public class CoreTestCommon {
    protected ThreadDump threadDump;
    private ExceptionTracker<?> exceptionTracker;

    @Before
    public void enableReferenceTracing() {
        AbstractReferenceCounted.enableReferenceTracing();
    }

    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void createExceptionTracker() {
        this.exceptionTracker = JvmExceptionTracker.create();
    }

    public void expectException(String message) {
        this.exceptionTracker.expectException(message);
    }

    public void ignoreException(String message) {
        this.exceptionTracker.ignoreException(message);
    }

    @After
    public void afterChecks() {
        CleaningThread.performCleanup((Thread)Thread.currentThread());
        AbstractCloseable.waitForCloseablesToClose((long)10000L);
        this.assertReferencesReleased();
        if (this.threadDump != null) {
            this.checkThreadDump();
        }
        this.exceptionTracker.checkExceptions();
        AbstractReferenceCounted.disableReferenceTracing();
    }

    protected void assertReferencesReleased() {
        ReferenceCountedUtils.assertReferencesReleased();
    }
}

