/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.Arrays;
import java.util.Collection;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JvmParseSizeTest
extends CoreTestCommon {
    public static final String PROPERTY = "JvmParseSizeTest";
    private final String text;
    private final long value;

    public JvmParseSizeTest(String text, long value) {
        this.text = text;
        this.value = value;
    }

    @Parameterized.Parameters(name="{0} => {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"100", 100L}, {"  100  ", 100L}, {"100b", 100L}, {"100B", 100L}, {"0.5kb", 512L}, {"0.5KiB", 512L}, {"0.125MB", 131072L}, {"2M", 0x200000L}, {" 2 M", 0x200000L}, {"0.75GiB", 0x30000000L}, {"1.5 GiB", 0x60000000L}, {"0.001TiB", Math.round(1.099511627776E9)});
    }

    @After
    public void teardown() {
        System.getProperties().remove(PROPERTY);
    }

    @Test
    public void parseSize() throws IllegalArgumentException {
        Assert.assertEquals((long)this.value, (long)Jvm.parseSize((String)this.text));
    }

    @Test
    public void getSize() {
        System.setProperty(PROPERTY, this.text);
        Assert.assertEquals((long)this.value, (long)Jvm.getSize((String)PROPERTY, (long)-1L));
    }
}

