/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.ConfigurationException;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.JvmTest$1My$;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import sun.nio.ch.DirectBuffer;

public class JvmTest
extends CoreTestCommon {
    private ThreadDump threadDump;

    @Override
    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @Override
    @After
    public void checkThreadDump() {
        Jvm.resetExceptionHandlers();
        this.threadDump.assertNoNewThreads();
    }

    @Test
    public void addToClassPath() {
        String propertyBefore = System.getProperty("java.class.path");
        Jvm.addToClassPath(JvmTest.class);
        String propertyAfter = System.getProperty("java.class.path");
        if (JvmTest.class.getClassLoader() instanceof URLClassLoader) {
            Assert.assertNotSame((Object)propertyBefore, (Object)propertyAfter);
        } else {
            Assert.assertSame((Object)propertyBefore, (Object)propertyAfter);
        }
    }

    @Test(expected=ConfigurationException.class)
    public void testRethrow() {
        throw Jvm.rethrow((Throwable)new ConfigurationException());
    }

    @Test
    public void shouldGetMajorVersion() {
        Assert.assertTrue((Jvm.majorVersion() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void resetExceptionHandlersSetHandlersBackToTheirDefaults() throws IllegalAccessException {
        Jvm.setExceptionHandlers(null, null, null, null);
        Jvm.resetExceptionHandlers();
        Assert.assertSame((Object)Jvm.getField(Jvm.class, (String)"DEFAULT_PERF_EXCEPTION_HANDLER").get(null), (Object)Jvm.perf().defaultHandler());
        Assert.assertSame((Object)Jvm.getField(Jvm.class, (String)"DEFAULT_WARN_EXCEPTION_HANDLER").get(null), (Object)Jvm.warn().defaultHandler());
        Assert.assertSame((Object)Jvm.getField(Jvm.class, (String)"DEFAULT_ERROR_EXCEPTION_HANDLER").get(null), (Object)Jvm.error().defaultHandler());
        Assert.assertSame((Object)Jvm.getField(Jvm.class, (String)"DEFAULT_DEBUG_EXCEPTION_HANDLER").get(null), (Object)Jvm.debug().defaultHandler());
    }

    @Test
    public void reportThis() {
        Map map = Jvm.recordExceptions();
        ReportUnoptimised.reportOnce();
        String actual = map.keySet().toString();
        Assert.assertTrue((String)actual, (boolean)actual.contains("JvmTest.reportThis(JvmTest.java"));
    }

    @Test
    public void testIsInternal() {
        Assert.assertTrue((boolean)Jvm.isInternal((String)String.class.getName()));
        Assert.assertFalse((boolean)Jvm.isInternal((String)this.getClass().getName()));
    }

    @Test
    public void testGetValue() {
        ByteBuffer bb = ByteBuffer.allocateDirect(128);
        long address = (Long)Jvm.getValue((Object)bb, (String)"address");
        Assert.assertEquals((long)((DirectBuffer)((Object)bb)).address(), (long)address);
    }

    @Test
    public void testUsedDirectMemory() {
        long used = Jvm.usedDirectMemory();
        ByteBuffer.allocateDirect(4096);
        Assert.assertEquals((long)(used + 4096L), (long)Jvm.usedDirectMemory());
    }

    @Test
    public void testMaxDirectMemory() {
        long maxDirectMemory = Jvm.maxDirectMemory();
        Assert.assertTrue((maxDirectMemory > 0L ? 1 : 0) != 0);
    }

    @Test
    public void enableSignals() {
        AtomicBoolean failed = new AtomicBoolean();
        ExceptionHandler handler = (c, m, t) -> failed.set(true);
        Jvm.setWarnExceptionHandler((ExceptionHandler)handler);
        Jvm.setErrorExceptionHandler((ExceptionHandler)handler);
        Jvm.addSignalHandler(signal -> System.out.println(signal + " occurred"));
        Assert.assertFalse((boolean)failed.get());
    }

    @Test
    public void classMetrics() throws IllegalArgumentException {
        Assume.assumeFalse((boolean)Jvm.isArm());
        String expect = "ClassMetrics{offset=" + Jvm.objectHeaderSize() + ", length=16}";
        Assert.assertEquals((Object)expect, (Object)Jvm.classMetrics(ClassA.class).toString());
        Assert.assertEquals((Object)expect, (Object)Jvm.classMetrics(ClassB.class).toString());
        Assert.assertEquals((Object)expect, (Object)Jvm.classMetrics(ClassC.class).toString());
        try {
            Jvm.classMetrics(ClassD.class);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void microPause() {
        for (int t = 0; t < 4; ++t) {
            long start = System.nanoTime();
            int count = 1000000;
            for (int i = 0; i < count; ++i) {
                Jvm.nanoPause();
            }
            long time = System.nanoTime() - start;
            long avg = time / (long)count;
            if (t <= 0) continue;
            System.out.println("Took " + avg + " ns to nanoPause()");
        }
    }

    @Test
    public void address() {
        ByteBuffer bb = ByteBuffer.allocateDirect(64);
        Assert.assertNotEquals((long)0L, (long)Jvm.address((ByteBuffer)bb));
        try {
            Jvm.address((ByteBuffer)ByteBuffer.allocate(64));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void arrayByteBaseOffset() {
        byte[] bytes = new byte[]{0};
        UnsafeMemory.MEMORY.writeByte((Object)bytes, (long)Jvm.arrayByteBaseOffset(), (byte)1);
        Assert.assertEquals((long)1L, (long)bytes[0]);
    }

    @Test
    public void doNotCloseOnInterrupt() throws IOException {
        AtomicBoolean failed = new AtomicBoolean();
        ExceptionHandler handler = (c, m, t) -> failed.set(true);
        Jvm.setWarnExceptionHandler((ExceptionHandler)handler);
        Jvm.setErrorExceptionHandler((ExceptionHandler)handler);
        try (FileChannel fc = FileChannel.open(Paths.get(OS.getTarget(), "doNotCloseOnInterrupt-" + Time.uniqueId() + ".tmp"), StandardOpenOption.APPEND, StandardOpenOption.CREATE_NEW, StandardOpenOption.DELETE_ON_CLOSE);){
            Jvm.doNotCloseOnInterrupt(this.getClass(), (FileChannel)fc);
        }
        Assert.assertFalse((boolean)failed.get());
    }

    @Test
    public void isProcessAliveTest() {
        long pid = Jvm.getProcessId();
        Assert.assertTrue((boolean)Jvm.isProcessAlive((long)pid));
        if (OS.isLinux()) {
            Assert.assertTrue((boolean)Jvm.isProcessAlive((long)1L));
        }
        Assert.assertFalse((boolean)Jvm.isProcessAlive((long)-1L));
    }

    @Test
    public void testGetMethod() {
        Assert.assertNotNull((Object)Jvm.getMethod(ClassIWDM.class, (String)"hello", (Class[])new Class[]{CharSequence.class}));
        boolean fail = false;
        try {
            Jvm.getMethod(ClassIWDM.class, (String)"helloDefault", (Class[])new Class[]{CharSequence.class});
            fail = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertFalse((boolean)fail);
    }

    @Test
    public void findAnnotationOnClass() {
        RealAnno ra = (RealAnno)Jvm.findAnnotation(Foo.class, RealAnno.class);
        Assert.assertEquals((Object)"Hello", (Object)ra.value());
    }

    @Test
    public void findAnnotationOnMethod() throws NoSuchMethodException {
        RealAnno ra = (RealAnno)Jvm.findAnnotation((AnnotatedElement)Foo.class.getDeclaredMethod("inheritedAnno", new Class[0]), RealAnno.class);
        Assert.assertEquals((Object)"Hello", (Object)ra.value());
        RealAnno ra2 = (RealAnno)Jvm.findAnnotation((AnnotatedElement)Foo.class.getDeclaredMethod("directAnno", new Class[0]), RealAnno.class);
        Assert.assertEquals((Object)"G'Day", (Object)ra2.value());
        RealAnno rab = (RealAnno)Jvm.findAnnotation((AnnotatedElement)Bar.class.getMethod("inheritedAnno", new Class[0]), RealAnno.class);
        Assert.assertEquals((Object)"Hello", (Object)rab.value());
        RealAnno rab2 = (RealAnno)Jvm.findAnnotation((AnnotatedElement)Bar.class.getMethod("directAnno", new Class[0]), RealAnno.class);
        Assert.assertEquals((Object)"G'Day", (Object)rab2.value());
        RealAnno raz = (RealAnno)Jvm.findAnnotation((AnnotatedElement)Baz.class.getMethod("inheritedAnno", new Class[0]), RealAnno.class);
        Assert.assertEquals((Object)"Hello", (Object)raz.value());
        RealAnno raz2 = (RealAnno)Jvm.findAnnotation((AnnotatedElement)Baz.class.getMethod("directAnno", new Class[0]), RealAnno.class);
        Assert.assertEquals((Object)"G'Day", (Object)raz2.value());
    }

    @Test
    public void findAnnotationOnField() throws NoSuchFieldException {
        RealAnno ra = (RealAnno)Jvm.findAnnotation((AnnotatedElement)DTO.class.getDeclaredField("inheritedAnno"), RealAnno.class);
        Assert.assertEquals((Object)"Hello", (Object)ra.value());
        RealAnno ra2 = (RealAnno)Jvm.findAnnotation((AnnotatedElement)DTO.class.getDeclaredField("directAnno"), RealAnno.class);
        Assert.assertEquals((Object)"G'Day", (Object)ra2.value());
    }

    @Test
    public void isLambdaClass() {
        Runnable r = () -> System.out.println("Hello, Lambda!");
        Assert.assertTrue((boolean)Jvm.isLambdaClass(r.getClass()));
        class Class {
            final /* synthetic */ JvmTest this$0;

            Class(JvmTest this$0) {
                this.this$0 = this$0;
            }
        }
        Assert.assertFalse((boolean)Jvm.isLambdaClass(Class.class));
    }

    @Test
    public void testCompileThreshold() {
        int threshold = Jvm.compileThreshold();
        Assert.assertTrue((threshold > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMajorVersion() {
        int majorVersion = Jvm.majorVersion();
        Assert.assertTrue((majorVersion >= 8 ? 1 : 0) != 0);
    }

    @Test
    public void testJavaVersionChecks() {
        Assert.assertEquals((Object)(Jvm.majorVersion() >= 9 ? 1 : 0), (Object)Jvm.isJava9Plus());
        Assert.assertEquals((Object)(Jvm.majorVersion() >= 12 ? 1 : 0), (Object)Jvm.isJava12Plus());
        Assert.assertEquals((Object)(Jvm.majorVersion() >= 14 ? 1 : 0), (Object)Jvm.isJava14Plus());
        Assert.assertEquals((Object)(Jvm.majorVersion() >= 15 ? 1 : 0), (Object)Jvm.isJava15Plus());
        Assert.assertEquals((Object)(Jvm.majorVersion() >= 19 ? 1 : 0), (Object)Jvm.isJava19Plus());
        Assert.assertEquals((Object)(Jvm.majorVersion() >= 20 ? 1 : 0), (Object)Jvm.isJava20Plus());
        Assert.assertEquals((Object)(Jvm.majorVersion() >= 21 ? 1 : 0), (Object)Jvm.isJava21Plus());
    }

    @Test
    public void testGetProcessId() {
        int processId = Jvm.getProcessId();
        Assert.assertTrue((processId > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTrimStackTrace() {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stes = new StackTraceElement[]{new StackTraceElement("Class1", "method1", "Class1.java", 1), new StackTraceElement("Class2", "method2", "Class2.java", 2)};
        Jvm.trimStackTrace((StringBuilder)sb, (StackTraceElement[])stes);
        Assert.assertTrue((boolean)sb.toString().contains("Class1.method1"));
        Assert.assertTrue((boolean)sb.toString().contains("Class2.method2"));
    }

    @Test
    public void testUsedNativeMemory() {
        long memory = Jvm.usedNativeMemory();
        Assert.assertTrue((memory >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testDisableDebugHandler() {
        Jvm.disableDebugHandler();
    }

    @Test
    public void testDisablePerfHandler() {
        Jvm.disablePerfHandler();
    }

    @Test
    public void testDisableWarnHandler() {
        Jvm.disableWarnHandler();
    }

    @Test
    public void testSetThreadLocalExceptionHandlers() {
        ExceptionHandler mockErrorHandler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        Jvm.setThreadLocalExceptionHandlers((ExceptionHandler)mockErrorHandler, null, null);
    }

    @Test
    public void testIsDebugEnabledAndIsPerfEnabled() {
        Assert.assertTrue((boolean)Jvm.isDebugEnabled(SomeClass.class));
        Assert.assertTrue((boolean)Jvm.isPerfEnabled(SomeClass.class));
    }

    @Test
    public void testGetSize() {
        long defaultValue = 1024L;
        Assert.assertEquals((long)defaultValue, (long)Jvm.getSize((String)"nonexistentProperty", (long)defaultValue));
    }

    @Test
    public void testGetCpuClass() {
        String cpuClass = Jvm.getCpuClass();
        Assert.assertNotNull((Object)cpuClass);
    }

    @Test
    public void testCommonInterruptible() {
        FileChannel mockFileChannel = (FileChannel)Mockito.mock(FileChannel.class);
        Jvm.CommonInterruptible commonInterruptible = new Jvm.CommonInterruptible(this.getClass(), mockFileChannel);
        commonInterruptible.interrupt();
    }

    @Test
    public void getPackageName() {
        Assert.assertEquals((Object)"net.openhft.chronicle.core", (Object)Jvm.getPackageName(Jvm.class));
    }

    static class Baz
    implements Bar {
        Baz() {
        }

        @Override
        public void inheritedAnno() {
        }

        @Override
        public void directAnno() {
        }
    }

    static interface Bar
    extends Foo {
    }

    @AnnoAlias
    static interface Foo {
        @AnnoAlias
        public void inheritedAnno();

        @RealAnno(value="G'Day")
        public void directAnno();
    }

    static class DTO {
        @AnnoAlias
        long inheritedAnno;
        @RealAnno(value="G'Day")
        double directAnno;

        DTO() {
        }
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @RealAnno(value="Hello")
    public static @interface AnnoAlias {
    }

    @Target(value={ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RealAnno {
        public String value();
    }

    static class SomeClass {
        private int somePrivateField;

        SomeClass() {
        }
    }

    static class ClassIWDM
    implements InterfaceWithDefaultMethod {
        ClassIWDM() {
        }

        @Override
        public void hello(CharSequence ignored) {
        }
    }

    static interface InterfaceWithDefaultMethod {
        public void hello(CharSequence var1);

        default public void helloDefault(CharSequence cs) {
            this.hello(cs);
        }
    }

    static class ClassD
    extends ClassC {
        byte x;

        ClassD() {
        }
    }

    static class ClassC
    extends ClassB {
        String hi;

        ClassC() {
        }
    }

    static class ClassB
    extends ClassA {
        String text;

        ClassB() {
        }
    }

    static class ClassA {
        long l;
        int i;
        short s;
        byte b;
        boolean flag;

        ClassA() {
        }
    }

    static final class ReportUnoptimised {
        private ReportUnoptimised() {
        }

        static void reportOnce() {
        }

        static {
            Jvm.reportUnoptimised();
        }
    }
}

