/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;
import sun.misc.Unsafe;

public class MemoryTest
extends CoreTestCommon {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadme() {
        @Nullable Memory memory = OS.memory();
        long address = memory.allocate(1024L);
        try {
            memory.writeInt(address, 1);
            Assert.assertEquals((long)1L, (long)memory.readInt(address));
            boolean swapped = memory.compareAndSwapInt(address, 1, 2);
            Assert.assertTrue((boolean)swapped);
            Assert.assertEquals((long)2L, (long)memory.readInt(address));
        }
        finally {
            memory.freeMemory(address, 1024L);
        }
    }

    @Test
    public void sizeOf() {
        Assert.assertEquals((long)Unsafe.ARRAY_BOOLEAN_INDEX_SCALE, (long)Memory.sizeOf(Boolean.TYPE));
        Assert.assertEquals((long)Unsafe.ARRAY_BYTE_INDEX_SCALE, (long)Memory.sizeOf(Byte.TYPE));
        Assert.assertEquals((long)Unsafe.ARRAY_CHAR_INDEX_SCALE, (long)Memory.sizeOf(Character.TYPE));
        Assert.assertEquals((long)Unsafe.ARRAY_SHORT_INDEX_SCALE, (long)Memory.sizeOf(Short.TYPE));
        Assert.assertEquals((long)Unsafe.ARRAY_INT_INDEX_SCALE, (long)Memory.sizeOf(Integer.TYPE));
        Assert.assertEquals((long)Unsafe.ARRAY_FLOAT_INDEX_SCALE, (long)Memory.sizeOf(Float.TYPE));
        Assert.assertEquals((long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE, (long)Memory.sizeOf(Double.TYPE));
        Assert.assertEquals((long)Unsafe.ARRAY_LONG_INDEX_SCALE, (long)Memory.sizeOf(Long.TYPE));
        Assert.assertEquals((long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, (long)Memory.sizeOf(Long.class));
    }
}

