/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.threads.ThreadDump;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.TestName;
import org.mockito.MockitoAnnotations;

public class OSTest
extends CoreTestCommon {
    @Rule
    public final TestName testName = new TestName();
    private ThreadDump threadDump;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    public void testIsSparseFileSupported() {
        boolean expected = System.getProperty("os.name").toLowerCase().contains("linux") && OS.is64Bit();
        Assert.assertEquals((Object)expected, (Object)OS.isSparseFileSupported());
    }

    @Test
    public void testFindTmp() {
        String tmp = OS.findTmp();
        Assert.assertNotNull((Object)tmp);
    }

    @Test
    public void testIPAddressHolder() {
        String ipAddress = OS.IPAddressHolder.IP_ADDRESS;
        Assert.assertNotNull((Object)ipAddress);
    }

    @Test
    public void testHostnameHolder() {
        String hostname = OS.HostnameHolder.HOST_NAME;
        Assert.assertNotNull((Object)hostname);
    }

    @Test
    public void testFindFile() {
        Assert.assertEquals((Object)new File("./last").getAbsolutePath(), (Object)OS.findFile((String[])new String[]{"first", "last"}).getAbsolutePath());
    }

    @Override
    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @Override
    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Test
    public void testIs64Bit() {
        boolean expected = Stream.of("com.ibm.vm.bitmode", "sun.arch.data.model").map(System::getProperty).filter(Objects::nonNull).anyMatch(p -> p.contains("64")) || Stream.of("java.vm.version").map(System::getProperty).filter(Objects::nonNull).anyMatch(p -> p.contains("_64"));
        Assert.assertEquals((Object)expected, (Object)OS.is64Bit());
    }

    @Test
    public void testGetProcessId() {
        int processId = OS.getProcessId();
        Assertions.assertTrue((processId > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMapGranularity() throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        File file = IOTools.createTempFile((String)(this.getClass().getName() + "." + this.testName.getMethodName()));
        try (RandomAccessFile rw = new RandomAccessFile(file, "rw");){
            FileChannel fc = rw.getChannel();
            long length = OS.pageSize();
            MappedByteBuffer anchor = fc.map(FileChannel.MapMode.READ_WRITE, 0L, length);
            anchor.order(ByteOrder.nativeOrder());
            long address = OS.map0((FileChannel)fc, (int)OS.imodeFor((FileChannel.MapMode)FileChannel.MapMode.READ_WRITE), (long)0L, (long)length);
            OS.memory().writeLong(address, 0L);
            OS.unmap((long)address, (long)length);
            Assert.assertEquals((long)length, (long)file.length());
        }
    }

    @Test
    public void testMap() throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        File file = IOTools.createTempFile((String)(this.getClass().getName() + "." + this.testName.getMethodName()));
        try (RandomAccessFile rw = new RandomAccessFile(file, "rw");){
            long offset;
            FileChannel fc = rw.getChannel();
            long length = 0x8000000L;
            long anchorSize = 0x40000000L;
            int anchorCount = (int)((length + anchorSize - 1L) / anchorSize);
            ArrayList<MappedByteBuffer> anchors = new ArrayList<MappedByteBuffer>();
            long anchorTotalRemain = length;
            for (int i = 0; i < anchorCount; ++i) {
                MappedByteBuffer anchor = fc.map(FileChannel.MapMode.READ_WRITE, (long)i * anchorSize, Math.min(anchorTotalRemain, anchorSize));
                anchor.order(ByteOrder.nativeOrder());
                anchors.add(anchor);
                anchorTotalRemain -= anchorSize;
            }
            long address = OS.map0((FileChannel)fc, (int)OS.imodeFor((FileChannel.MapMode)FileChannel.MapMode.READ_WRITE), (long)0L, (long)length);
            for (offset = 0L; offset < length; offset += (long)OS.pageSize()) {
                OS.memory().writeLong(address + offset, offset);
            }
            for (offset = 0L; offset < length; offset += (long)OS.pageSize()) {
                Assert.assertEquals((long)offset, (long)OS.memory().readLong(address + offset));
            }
            OS.unmap((long)address, (long)length);
        }
    }

    @Test
    public void testMapFast() throws Exception {
        File file = IOTools.createTempFile((String)(this.getClass().getName() + "." + this.testName.getMethodName()));
        try (RandomAccessFile rw = new RandomAccessFile(file, "rw");){
            FileChannel fc = rw.getChannel();
            long length = 8L;
            MappedByteBuffer anchor = fc.map(FileChannel.MapMode.READ_WRITE, 0L, length);
            anchor.order(ByteOrder.nativeOrder());
            long address = OS.map0((FileChannel)fc, (int)OS.imodeFor((FileChannel.MapMode)FileChannel.MapMode.READ_WRITE), (long)0L, (long)length);
            long value = System.currentTimeMillis();
            value ^= value << 32;
            OS.memory().writeLong(address, value);
            Assert.assertEquals((long)value, (long)OS.memory().readLong(address));
            Assert.assertEquals((long)value, (long)anchor.getLong(0));
            OS.unmap((long)address, (long)length);
        }
    }

    @Test
    public void getHostname() throws IOException {
        System.out.println("exec hostname: " + OS.HostnameHolder.execHostname());
        String hostName = OS.getHostName();
        System.out.println("hostname: " + hostName);
        Assert.assertNotNull((Object)hostName);
        Assert.assertNotEquals((Object)"", (Object)hostName);
        Assume.assumeTrue((OS.isWindows() || OS.isLinux() || OS.isMacOSX() ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)"localhost", (Object)hostName);
    }

    @Test
    public void getIPAddress() {
        System.out.println("getIpAddressByLocalHost: " + OS.IPAddressHolder.getIpAddressByLocalHost());
        System.out.println("getIpAddressByDatagram " + OS.IPAddressHolder.getIpAddressByDatagram());
        System.out.println("getIpAddressBySocket: " + OS.IPAddressHolder.getIpAddressBySocket());
        String ipAddress = OS.getIPAddress();
        System.out.println("ipAddress: " + ipAddress);
        Assert.assertNotNull((Object)ipAddress);
        Assert.assertNotEquals((Object)"", (Object)ipAddress);
        Assume.assumeTrue((OS.isWindows() || OS.isLinux() || OS.isMacOSX() ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)"0.0.0.0", (Object)ipAddress);
    }

    @Test
    public void getTarget() {
        String target = OS.getTarget();
        if (!target.endsWith("/target")) {
            Assert.assertEquals((Object)"target", (Object)target);
        }
    }

    @Test
    public void getTmp() {
        String tmp = OS.getTmp();
        Assert.assertNotNull((Object)tmp);
    }

    @Test
    public void mapAlign() {
        Assert.assertEquals((long)0L, (long)OS.mapAlign((long)0L, (int)64));
        Assert.assertEquals((long)64L, (long)OS.mapAlign((long)1L, (int)64));
        Assert.assertEquals((long)128L, (long)OS.mapAlign((long)96L, (int)64));
        Assert.assertEquals((long)0L, (long)OS.mapAlign((long)0L, (int)1024));
        Assert.assertEquals((long)1024L, (long)OS.mapAlign((long)1024L, (int)1024));
        Assert.assertEquals((long)2048L, (long)OS.mapAlign((long)1025L, (int)1024));
        Assert.assertEquals((long)0L, (long)OS.mapAlign((long)0L, (int)4096));
        Assert.assertEquals((long)4096L, (long)OS.mapAlign((long)1L, (int)4096));
        Assert.assertEquals((long)4096L, (long)OS.mapAlign((long)4096L, (int)4096));
        Assert.assertEquals((long)8192L, (long)OS.mapAlign((long)4097L, (int)4096));
        int customPageSize = 0x200000;
        Assert.assertEquals((long)0L, (long)OS.mapAlign((long)0L, (int)customPageSize));
        Assert.assertEquals((long)customPageSize, (long)OS.mapAlign((long)1L, (int)customPageSize));
        Assert.assertEquals((long)customPageSize, (long)OS.mapAlign((long)customPageSize, (int)customPageSize));
        Assert.assertEquals((long)(2 * customPageSize), (long)OS.mapAlign((long)(customPageSize + 1), (int)customPageSize));
        Assert.assertEquals((long)(2 * customPageSize), (long)OS.mapAlign((long)(2 * customPageSize - 1), (int)customPageSize));
        Assert.assertEquals((long)42L, (long)OS.mapAlign((long)42L, (int)1));
        Assert.assertEquals((long)0x40000000L, (long)OS.mapAlign((long)0x3FFFFFFFL, (int)4096));
        Assert.assertThrows(IllegalArgumentException.class, () -> OS.mapAlign((long)-1L, (int)64));
        Assert.assertThrows(IllegalArgumentException.class, () -> OS.mapAlign((long)10L, (int)-64));
        Assert.assertThrows(IllegalArgumentException.class, () -> OS.mapAlign((long)10L, (int)0));
    }

    @Test
    public void pageAlign() {
        Assert.assertEquals((long)0L, (long)OS.pageAlign((long)0L, (int)64));
        Assert.assertEquals((long)64L, (long)OS.pageAlign((long)1L, (int)64));
        Assert.assertEquals((long)128L, (long)OS.pageAlign((long)96L, (int)64));
        Assert.assertEquals((long)0L, (long)OS.pageAlign((long)0L, (int)1024));
        Assert.assertEquals((long)1024L, (long)OS.pageAlign((long)1024L, (int)1024));
        Assert.assertEquals((long)2048L, (long)OS.pageAlign((long)1025L, (int)1024));
        Assert.assertEquals((long)0L, (long)OS.pageAlign((long)0L, (int)4096));
        Assert.assertEquals((long)4096L, (long)OS.pageAlign((long)1L, (int)4096));
        Assert.assertEquals((long)4096L, (long)OS.pageAlign((long)4096L, (int)4096));
        Assert.assertEquals((long)8192L, (long)OS.pageAlign((long)4097L, (int)4096));
        int customPageSize = 0x200000;
        Assert.assertEquals((long)0L, (long)OS.pageAlign((long)0L, (int)customPageSize));
        Assert.assertEquals((long)customPageSize, (long)OS.pageAlign((long)1L, (int)customPageSize));
        Assert.assertEquals((long)customPageSize, (long)OS.pageAlign((long)customPageSize, (int)customPageSize));
        Assert.assertEquals((long)(2 * customPageSize), (long)OS.pageAlign((long)(customPageSize + 1), (int)customPageSize));
        Assert.assertEquals((long)(2 * customPageSize), (long)OS.pageAlign((long)(2 * customPageSize - 1), (int)customPageSize));
    }

    @Test
    public void testGetUserName() {
        String expectedUserName = System.getProperty("user.name");
        Assert.assertEquals((Object)expectedUserName, (Object)OS.getUserName());
    }

    @Test
    public void testPageAlign() {
        long size = 12345L;
        long expectedAlignedSize = size + (long)OS.pageSize() - 1L & (long)(~(OS.pageSize() - 1));
        Assert.assertEquals((long)expectedAlignedSize, (long)OS.pageAlign((long)size));
    }

    @Test
    public void testMapAlign() {
        long offset = 6000L;
        long expectedAlignedOffset = offset + (long)OS.defaultOsPageSize() - 1L & (long)(~(OS.defaultOsPageSize() - 1));
        Assert.assertEquals((long)expectedAlignedOffset, (long)OS.mapAlign((long)offset));
        Assert.assertThrows(IllegalArgumentException.class, () -> OS.mapAlign((long)-1L));
    }

    @Test
    public void testGetProcessId0() {
        int processId = OS.getProcessId0();
        Assertions.assertTrue((processId > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetPidMax() {
        long pidMax = OS.getPidMax();
        Assertions.assertTrue((pidMax > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testUserDir() {
        String expectedUserDir = System.getProperty("user.dir");
        Assert.assertEquals((Object)expectedUserDir, (Object)OS.userDir());
    }

    @Test
    public void testGetHostName0() {
        String expectedHostName = null;
        if (OS.isWindows() && (expectedHostName = System.getenv("COMPUTERNAME")) != null) {
            expectedHostName = expectedHostName.toLowerCase();
        }
        if (expectedHostName == null) {
            try {
                expectedHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable ignored) {
                expectedHostName = "localhost";
            }
        }
        Assert.assertEquals((Object)expectedHostName, (Object)OS.HostnameHolder.HOST_NAME);
    }
}

