/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import org.junit.Assert;
import org.junit.Test;

public class StackTraceTest
extends CoreTestCommon {
    private static final CountDownLatch threadStarted = new CountDownLatch(1);

    static void thinking() {
        threadStarted.countDown();
        Jvm.pause((long)5000L);
    }

    @Test
    public void testDefaultConstructor() {
        StackTrace st = new StackTrace();
        Assert.assertEquals((Object)("stack trace on " + Thread.currentThread().getName()), (Object)st.getMessage());
    }

    @Test
    public void testConstructorWithMessage() {
        String message = "test message";
        StackTrace st = new StackTrace(message);
        Assert.assertEquals((Object)(message + " on " + Thread.currentThread().getName()), (Object)st.getMessage());
    }

    @Test
    public void testConstructorWithMessageAndCause() {
        String message = "test message";
        RuntimeException cause = new RuntimeException("cause");
        StackTrace st = new StackTrace(message, (Throwable)cause);
        Assert.assertEquals((Object)(message + " on " + Thread.currentThread().getName()), (Object)st.getMessage());
        Assert.assertEquals((Object)cause, (Object)st.getCause());
    }

    @Test
    public void testForThread() {
        Thread thread = new Thread();
        StackTrace st = StackTrace.forThread((Thread)thread);
        Assert.assertNotNull((Object)st);
        Assert.assertEquals((Object)thread.toString(), (Object)st.getMessage().replace(" on " + Thread.currentThread().getName(), ""));
        Assert.assertNull((Object)StackTrace.forThread(null));
    }

    @Test
    public void forThread() throws InterruptedException {
        Jvm.init();
        Thread t = new Thread(StackTraceTest::thinking, "background");
        t.start();
        boolean started = threadStarted.await(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)started);
        Jvm.pause((long)50L);
        StackTrace st = StackTrace.forThread((Thread)t);
        t.interrupt();
        if (Jvm.isJava20Plus()) {
            Assert.assertTrue((boolean)st.getMessage().endsWith("background,5,main] on main"));
            Assert.assertEquals((Object)"net.openhft.chronicle.core.Jvm.pause", (Object)st.getStackTrace()[1].toString().split("\\(")[0].replaceAll("^app//", ""));
        } else {
            Assert.assertEquals((Object)"Thread[background,5,main] on main", (Object)st.getMessage());
            Assert.assertEquals((Object)"net.openhft.chronicle.core.Jvm.pause", (Object)st.getStackTrace()[0].toString().split("\\(")[0].replaceAll("^app//", ""));
        }
    }
}

