/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.Arrays;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.UnsafeMemoryTestMixin;
import net.openhft.chronicle.testframework.Series;

final class UnsafeMemoryIntTest
implements UnsafeMemoryTestMixin<Integer> {
    UnsafeMemoryIntTest() {
    }

    @Override
    public Class<Integer> type() {
        return Integer.class;
    }

    @Override
    public IntPredicate alignedToType() {
        return x -> x % 4 == 0;
    }

    @Override
    public Integer zero() {
        return 0;
    }

    @Override
    public Integer nonZero() {
        return Integer.MIN_VALUE;
    }

    @Override
    public Stream<Integer> sequence() {
        return Series.powersOfTwo().limit(31L).flatMap(i -> LongStream.of(-i - 1L, -i, -i + 1L, i - 1L, i, i + 1L)).filter(i -> i > Integer.MIN_VALUE && i < Integer.MAX_VALUE).distinct().sorted().mapToObj(i -> (int)i);
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Integer>>> addressWriteOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Integer>>("UnsafeMemory::unsafePutInt", (m, a, v) -> UnsafeMemory.unsafePutInt((long)a, (int)v)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Integer>>("UnsafeMemory::writeInt", UnsafeMemory::writeInt), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Integer>>("UnsafeMemory::writeVolatileInt", UnsafeMemory::writeVolatileInt));
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Integer>>> addressReadOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Integer>>("UnsafeMemory::unsafeGetInt", (m, a) -> UnsafeMemory.unsafeGetInt((long)a)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Integer>>("UnsafeMemory::readInt", UnsafeMemory::readInt), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Integer>>("UnsafeMemory::readVolatileInt", UnsafeMemory::readVolatileInt));
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Integer>>> objectWriteOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Integer>>("UnsafeMemory::unsafePutInt(Object)", (m, obj, offset, v) -> UnsafeMemory.unsafePutInt((Object)obj, (long)offset, (int)v)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Integer>>("UnsafeMemory::writeInt", UnsafeMemory::writeInt), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Integer>>("UnsafeMemory::writeVolatileInt", UnsafeMemory::writeVolatileInt));
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Integer>>> objectReadOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Integer>>("UnsafeMemory::unsafeGetInt", (m, o, a) -> UnsafeMemory.unsafeGetInt((Object)o, (long)a)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Integer>>("UnsafeMemory::readInt", (m, o, a) -> UnsafeMemory.unsafeGetInt((Object)o, (long)a)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Integer>>("UnsafeMemory::readVolatileInt", UnsafeMemory::readVolatileInt));
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryLongObjConsumer<Integer> addressWriteVolatileOperation() {
        return UnsafeMemory::writeVolatileInt;
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryLongFunction<Integer> addressReadVolatileOperation() {
        return UnsafeMemory::readVolatileInt;
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Integer> objectWriteVolatileOperation() {
        return UnsafeMemory::writeVolatileInt;
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryObjLongFunction<Integer> objectReadVolatileOperation() {
        return UnsafeMemory::readVolatileInt;
    }
}

