/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.Arrays;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.UnsafeMemoryTestMixin;
import net.openhft.chronicle.testframework.Series;

final class UnsafeMemoryLongTest
implements UnsafeMemoryTestMixin<Long> {
    UnsafeMemoryLongTest() {
    }

    @Override
    public Class<Long> type() {
        return Long.class;
    }

    @Override
    public IntPredicate alignedToType() {
        return x -> x % 8 == 0;
    }

    @Override
    public Long zero() {
        return 0L;
    }

    @Override
    public Long nonZero() {
        return Long.MIN_VALUE;
    }

    @Override
    public Stream<Long> sequence() {
        return Series.powersOfTwo().limit(31L).flatMap(i -> LongStream.of(-i - 1L, -i, -i + 1L, i - 1L, i, i + 1L)).filter(i -> i > Integer.MIN_VALUE && i < Integer.MAX_VALUE).distinct().sorted().boxed();
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Long>>> addressWriteOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Long>>("UnsafeMemory::unsafePutLong", (m, a, v) -> UnsafeMemory.unsafePutLong((long)a, (long)v)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Long>>("UnsafeMemory::writeLong", UnsafeMemory::writeLong), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Long>>("UnsafeMemory::writeVolatileLong", UnsafeMemory::writeVolatileLong));
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Long>>> addressReadOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Long>>("UnsafeMemory::unsafeGetLong", (m, a) -> UnsafeMemory.unsafeGetLong((long)a)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Long>>("UnsafeMemory::readLong", UnsafeMemory::readLong), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Long>>("UnsafeMemory::readVolatileLong", UnsafeMemory::readVolatileLong));
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Long>>> objectWriteOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Long>>("UnsafeMemory::unsafePutLong(Object)", (m, obj, offset, v) -> UnsafeMemory.unsafePutLong((Object)obj, (long)offset, (long)v)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Long>>("UnsafeMemory::writeLong", UnsafeMemory::writeLong), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Long>>("UnsafeMemory::writeVolatileLong", UnsafeMemory::writeVolatileLong));
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Long>>> objectReadOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Long>>("UnsafeMemory::unsafeGetLong", (m, o, a) -> UnsafeMemory.unsafeGetLong((Object)o, (long)a)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Long>>("UnsafeMemory::readLong", (m, o, a) -> UnsafeMemory.unsafeGetLong((Object)o, (long)a)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Long>>("UnsafeMemory::readVolatileLong", UnsafeMemory::readVolatileLong));
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryLongObjConsumer<Long> addressWriteVolatileOperation() {
        return UnsafeMemory::writeVolatileLong;
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryLongFunction<Long> addressReadVolatileOperation() {
        return UnsafeMemory::readVolatileLong;
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Long> objectWriteVolatileOperation() {
        return UnsafeMemory::writeVolatileLong;
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryObjLongFunction<Long> objectReadVolatileOperation() {
        return UnsafeMemory::readVolatileLong;
    }
}

