/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.util.MisAlignedAssertionError;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnsafeMemoryTest
extends CoreTestCommon {
    private static final float EPSILON = 1.0E-7f;
    private static final byte BYTE_VAL = 127;
    private static final short SHORT_VAL = Short.MAX_VALUE;
    private static final int INT_VAL = 305419896;
    private static final long LONG_VAL = Long.MAX_VALUE;
    private static final float FLOAT_VAL = 1.0f;
    private static final double DOUBLE_VAL = 1.0;
    @Rule
    public final TestName testName = new TestName();
    private final String name;
    private final UnsafeMemory memory;
    private Boolean onHeap;
    private Object object;
    private long addr;

    public UnsafeMemoryTest(String name, UnsafeMemory memory, Boolean onHeap) {
        this.name = name;
        this.memory = memory;
        this.onHeap = onHeap;
        if (Boolean.TRUE.equals(onHeap)) {
            this.object = new byte[128];
            this.addr = memory.arrayBaseOffset(byte[].class);
        } else {
            this.object = null;
            this.addr = UnsafeMemory.UNSAFE.allocateMemory(128L);
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        UnsafeMemory.ARMMemory memory2 = new UnsafeMemory.ARMMemory();
        Object[][] arm = new Object[][]{{"ARMMemory onheap", memory2, true}, {"ARMMemory offheap", memory2, false}, {"ARMMemory offheap (no object)", memory2, null}, {"ARMMemory onheap (2)", memory2, true}};
        if (Jvm.isArm()) {
            return Arrays.asList(arm);
        }
        UnsafeMemory memory1 = new UnsafeMemory();
        Object[][] intel = new Object[][]{{"UnsafeMemory offheap", memory1, false}, {"UnsafeMemory onheap", memory1, true}, {"UnsafeMemory offheap (no object)", memory1, null}};
        ArrayList<Object[]> all = new ArrayList<Object[]>();
        Collections.addAll(all, intel);
        Collections.addAll(all, arm);
        return all;
    }

    @Before
    public void setUp() {
        System.err.println("testName: " + this.testName.getMethodName() + ", object: " + this.object + ", addr: " + this.addr);
        if (this.object == null && this.addr == 0L) {
            this.addr = UnsafeMemory.UNSAFE.allocateMemory(128L);
        }
    }

    @After
    public void tearDown() {
        if (this.object == null) {
            UnsafeMemory.UNSAFE.freeMemory(this.addr);
            this.addr = 0L;
        }
        System.gc();
    }

    @Test
    public void testUnsafeBooleanOperations() throws NoSuchFieldException {
        TestClass testObj = new TestClass();
        long offset = UnsafeMemory.UNSAFE.objectFieldOffset(TestClass.class.getDeclaredField("booleanField"));
        UnsafeMemory.unsafePutBoolean((Object)testObj, (long)offset, (boolean)true);
        Assert.assertTrue((boolean)UnsafeMemory.unsafeGetBoolean((Object)testObj, (long)offset));
    }

    @Test
    public void testUnsafeCharOperations() throws NoSuchFieldException {
        class CharHolder {
            char value;

            CharHolder() {
            }
        }
        CharHolder holder = new CharHolder();
        long offset = UnsafeMemory.UNSAFE.objectFieldOffset(CharHolder.class.getDeclaredField("value"));
        char testChar = 'A';
        UnsafeMemory.unsafePutChar((Object)holder, (long)offset, (char)testChar);
        Assert.assertEquals((long)testChar, (long)UnsafeMemory.unsafeGetChar((Object)holder, (long)offset));
    }

    @Test
    public void testUnsafeFloatOperations() throws NoSuchFieldException {
        class FloatHolder {
            float value;

            FloatHolder() {
            }
        }
        FloatHolder holder = new FloatHolder();
        long offset = UnsafeMemory.UNSAFE.objectFieldOffset(FloatHolder.class.getDeclaredField("value"));
        float testFloat = 1.23f;
        UnsafeMemory.unsafePutFloat((Object)holder, (long)offset, (float)testFloat);
        Assert.assertEquals((float)testFloat, (float)UnsafeMemory.unsafeGetFloat((Object)holder, (long)offset), (float)0.0f);
    }

    @Test
    public void testUnsafeDoubleOperations() throws NoSuchFieldException {
        TestClass testObj = new TestClass();
        long offset = UnsafeMemory.UNSAFE.objectFieldOffset(TestClass.class.getDeclaredField("doubleField"));
        double testValue = 123.456;
        UnsafeMemory.unsafePutDouble((Object)testObj, (long)offset, (double)testValue);
        Assert.assertEquals((double)testValue, (double)UnsafeMemory.unsafeGetDouble((Object)testObj, (long)offset), (double)0.0);
    }

    @Test
    public void testUnsafeObjectOperations() throws NoSuchFieldException {
        class ObjectHolder {
            Object value;

            ObjectHolder() {
            }
        }
        ObjectHolder holder = new ObjectHolder();
        long offset = UnsafeMemory.UNSAFE.objectFieldOffset(ObjectHolder.class.getDeclaredField("value"));
        String testObject = "Hello, World!";
        UnsafeMemory.unsafePutObject((Object)holder, (long)offset, (Object)testObject);
        Assert.assertEquals((Object)testObject, (Object)UnsafeMemory.unsafeGetObject((Object)holder, (long)offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteReadBytes() {
        UnsafeMemory memory = UnsafeMemory.INSTANCE;
        byte[] originalBytes = new byte[]{1, 2, 3, 4};
        byte[] buffer = new byte[4];
        long address = UnsafeMemory.UNSAFE.allocateMemory(4L);
        try {
            memory.writeBytes(address, originalBytes, 0, originalBytes.length);
            memory.readBytes(address, buffer, 0L, buffer.length);
            Assert.assertArrayEquals((byte[])originalBytes, (byte[])buffer);
        }
        finally {
            UnsafeMemory.UNSAFE.freeMemory(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTestAndSetInt() {
        UnsafeMemory memory = UnsafeMemory.INSTANCE;
        long address = UnsafeMemory.UNSAFE.allocateMemory(4L);
        try {
            UnsafeMemory.UNSAFE.putInt(address, 0);
            memory.testAndSetInt(address, 0L, 0, 10);
            Assert.assertEquals((long)10L, (long)UnsafeMemory.UNSAFE.getInt(address));
            Assert.assertThrows(IllegalStateException.class, () -> memory.testAndSetInt(address, 0L, 0, 20));
        }
        finally {
            UnsafeMemory.UNSAFE.freeMemory(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopy8bitAndIsEqual() {
        UnsafeMemory memory = UnsafeMemory.INSTANCE;
        String testString = "Hello, World!";
        int length = testString.length();
        long address = UnsafeMemory.UNSAFE.allocateMemory(length);
        try {
            memory.copy8bit(testString, 0, length, address);
            Assert.assertTrue((boolean)memory.isEqual(address, testString, length));
        }
        finally {
            UnsafeMemory.UNSAFE.freeMemory(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadVolatileFloat() {
        UnsafeMemory memory = UnsafeMemory.INSTANCE;
        long address = UnsafeMemory.UNSAFE.allocateMemory(4L);
        try {
            float expectedValue = 12.34f;
            UnsafeMemory.UNSAFE.putFloat(address, expectedValue);
            float actualValue = memory.readVolatileFloat(address);
            Assert.assertEquals((float)expectedValue, (float)actualValue, (float)0.0f);
        }
        finally {
            UnsafeMemory.UNSAFE.freeMemory(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTestAndSetIntMemoryAddress() {
        UnsafeMemory memory = UnsafeMemory.INSTANCE;
        long address = UnsafeMemory.UNSAFE.allocateMemory(4L);
        try {
            int expected = 100;
            int newValue = 200;
            UnsafeMemory.UNSAFE.putInt(address, expected);
            memory.testAndSetInt(address, 0L, expected, newValue);
            Assert.assertEquals((long)newValue, (long)UnsafeMemory.UNSAFE.getInt(address));
            Assert.assertThrows(IllegalStateException.class, () -> memory.testAndSetInt(address, 0L, expected, 300));
        }
        finally {
            UnsafeMemory.UNSAFE.freeMemory(address);
        }
    }

    @Test
    public void testTestAndSetIntObjectField() throws NoSuchFieldException {
        UnsafeMemory memory = UnsafeMemory.INSTANCE;
        TestObject obj = new TestObject();
        long offset = UnsafeMemory.UNSAFE.objectFieldOffset(TestObject.class.getDeclaredField("value"));
        int expected = 10;
        int newValue = 20;
        obj.value = expected;
        memory.testAndSetInt((Object)obj, offset, expected, newValue);
        Assert.assertEquals((long)newValue, (long)obj.value);
        Assert.assertThrows(IllegalStateException.class, () -> memory.testAndSetInt((Object)obj, offset, expected, 30));
    }

    @Test
    public void writeShort() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeShort(this.addr + (long)i, (short)-21555);
                Assert.assertEquals((long)-21555L, (long)this.memory.readShort(this.addr + (long)i));
                continue;
            }
            this.memory.writeShort(this.object, this.addr + (long)i, (short)-21555);
            Assert.assertEquals((long)-21555L, (long)this.memory.readShort(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void readShort() {
        if (this.onHeap == null) {
            this.memory.writeLong(this.addr, 81985529216486895L);
            Assert.assertEquals((long)-12817L, (long)this.memory.readShort(this.addr));
            Assert.assertEquals((long)-21555L, (long)this.memory.readShort(this.addr + 1L));
        } else {
            this.memory.writeLong(this.object, this.addr, 81985529216486895L);
            Assert.assertEquals((long)-12817L, (long)this.memory.readShort(this.object, this.addr));
            Assert.assertEquals((long)-21555L, (long)this.memory.readShort(this.object, this.addr + 1L));
        }
    }

    @Test
    public void readWriteInt() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeInt(this.addr + (long)i, 305419896);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                continue;
            }
            this.memory.writeInt(this.object, this.addr + (long)i, 305419896);
            Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void writeOrderedInt() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeOrderedInt(this.addr + (long)i, 305419896);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                continue;
            }
            this.memory.writeOrderedInt(this.object, this.addr + (long)i, 305419896);
            Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void readWriteLong() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeLong(this.addr + (long)i, Long.MAX_VALUE);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.addr + (long)i));
                continue;
            }
            this.memory.writeLong(this.object, this.addr + (long)i, Long.MAX_VALUE);
            Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void readWriteFloat() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeFloat(this.addr + (long)i, 1.0f);
                Assert.assertEquals((float)1.0f, (float)this.memory.readFloat(this.addr + (long)i), (float)1.0E-7f);
                continue;
            }
            this.memory.writeFloat(this.object, this.addr + (long)i, 1.0f);
            Assert.assertEquals((float)1.0f, (float)this.memory.readFloat(this.object, this.addr + (long)i), (float)1.0E-7f);
        }
    }

    @Test
    public void readWriteDouble() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeDouble(this.addr + (long)i, 1.0);
                Assert.assertEquals((double)1.0, (double)this.memory.readDouble(this.addr + (long)i), (double)1.0E-7f);
                continue;
            }
            this.memory.writeDouble(this.object, this.addr + (long)i, 1.0);
            Assert.assertEquals((double)1.0, (double)this.memory.readDouble(this.object, this.addr + (long)i), (double)1.0E-7f);
        }
    }

    @Test
    public void writeOrderedLong() {
        for (int i = (int)(-this.addr & 7L); i <= 64; i += 8) {
            if (this.onHeap == null) {
                this.memory.writeOrderedLong(this.addr + (long)i, Long.MAX_VALUE);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.addr + (long)i));
                continue;
            }
            this.memory.writeOrderedLong(this.object, this.addr + (long)i, Long.MAX_VALUE);
            Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.object, this.addr + (long)i));
        }
        System.err.println("DONE");
    }

    @Test
    public void compareAndSwapInt() throws MisAlignedAssertionError {
        for (int i = 0; i <= 64; i += 4) {
            try {
                boolean actual;
                if (this.onHeap == null) {
                    this.memory.writeInt(this.addr + (long)i, 0);
                    actual = this.memory.compareAndSwapInt(this.addr + (long)i, 0, 305419896);
                    Assert.assertTrue((boolean)actual);
                    Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                    continue;
                }
                this.memory.writeInt(this.object, this.addr + (long)i, 0);
                actual = this.memory.compareAndSwapInt(this.object, this.addr + (long)i, 0, 305419896);
                Assert.assertTrue((boolean)actual);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
                continue;
            }
            catch (MisAlignedAssertionError e) {
                if (!this.memory.safeAlignedInt(this.addr + (long)i)) continue;
                throw e;
            }
        }
    }

    @Test
    public void compareAndSwapLong() throws MisAlignedAssertionError {
        for (int i = (int)(-this.addr & 7L); i <= 64; i += 8) {
            try {
                boolean actual;
                if (this.onHeap == null) {
                    this.memory.writeLong(this.addr + (long)i, 0L);
                    actual = this.memory.compareAndSwapLong(this.addr + (long)i, 0L, Long.MAX_VALUE);
                    Assert.assertTrue((boolean)actual);
                    Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.addr + (long)i));
                    continue;
                }
                this.memory.writeLong(this.object, this.addr + (long)i, 0L);
                actual = this.memory.compareAndSwapLong(this.object, this.addr + (long)i, 0L, Long.MAX_VALUE);
                Assert.assertTrue((boolean)actual);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.object, this.addr + (long)i));
                continue;
            }
            catch (MisAlignedAssertionError e) {
                if (!this.memory.safeAlignedLong(this.addr + (long)i)) continue;
                throw e;
            }
        }
    }

    @Test
    public void getAndSetInt() throws MisAlignedAssertionError {
        int initialValue = 9876;
        for (int i = 0; i <= 64; i += 4) {
            try {
                int previous;
                if (this.onHeap == null) {
                    this.memory.writeInt(this.addr + (long)i, initialValue);
                    previous = this.memory.getAndSetInt(this.addr + (long)i, 305419896);
                    Assert.assertEquals((long)initialValue, (long)previous);
                    Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                    continue;
                }
                this.memory.writeInt(this.object, this.addr + (long)i, initialValue);
                previous = this.memory.getAndSetInt(this.object, this.addr + (long)i, 305419896);
                Assert.assertEquals((long)initialValue, (long)previous);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
                continue;
            }
            catch (MisAlignedAssertionError e) {
                if (!this.memory.safeAlignedInt(this.addr + (long)i)) continue;
                throw e;
            }
        }
    }

    @Test
    public void readVolatileByte() {
        for (int i = 0; i <= 64; ++i) {
            byte actual;
            if (this.onHeap == null) {
                this.memory.writeByte(this.addr + (long)i, (byte)127);
                actual = this.memory.readVolatileByte(this.addr + (long)i);
                Assert.assertEquals((long)127L, (long)actual);
                continue;
            }
            this.memory.writeByte(this.object, this.addr + (long)i, (byte)127);
            actual = this.memory.readVolatileByte(this.object, this.addr + (long)i);
            Assert.assertEquals((long)127L, (long)actual);
        }
    }

    @Test
    public void readVolatileShort() {
        for (int i = 0; i <= 64; i += 2) {
            short actual;
            if (this.onHeap == null) {
                this.memory.writeShort(this.addr + (long)i, (short)Short.MAX_VALUE);
                actual = this.memory.readVolatileShort(this.addr + (long)i);
                Assert.assertEquals((long)32767L, (long)actual);
                continue;
            }
            this.memory.writeShort(this.object, this.addr + (long)i, (short)Short.MAX_VALUE);
            actual = this.memory.readVolatileShort(this.object, this.addr + (long)i);
            Assert.assertEquals((long)32767L, (long)actual);
        }
    }

    @Test
    public void readVolatileInt() {
        for (int i = 0; i <= 64; i += 4) {
            int actual;
            if (this.onHeap == null) {
                this.memory.writeInt(this.addr + (long)i, 305419896);
                actual = this.memory.readVolatileInt(this.addr + (long)i);
                Assert.assertEquals((long)305419896L, (long)actual);
                continue;
            }
            this.memory.writeInt(this.object, this.addr + (long)i, 305419896);
            actual = this.memory.readVolatileInt(this.object, this.addr + (long)i);
            Assert.assertEquals((long)305419896L, (long)actual);
        }
    }

    @Test
    public void readVolatileFloat() {
        for (int i = 0; i <= 64; i += 4) {
            float actual;
            if (this.onHeap == null) {
                this.memory.writeFloat(this.addr + (long)i, 1.0f);
                actual = this.memory.readVolatileFloat(this.addr + (long)i);
                Assert.assertEquals((float)1.0f, (float)actual, (float)1.0E-7f);
                continue;
            }
            this.memory.writeFloat(this.object, this.addr + (long)i, 1.0f);
            actual = this.memory.readVolatileFloat(this.object, this.addr + (long)i);
            Assert.assertEquals((float)1.0f, (float)actual, (float)1.0E-7f);
        }
    }

    @Test
    public void readVolatileLong() {
        for (int i = (int)(-this.addr & 7L); i <= 64; i += 8) {
            long actual;
            if (this.onHeap == null) {
                this.memory.writeLong(this.addr + (long)i, Long.MAX_VALUE);
                actual = this.memory.readVolatileLong(this.addr + (long)i);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)actual);
                continue;
            }
            this.memory.writeLong(this.object, this.addr + (long)i, Long.MAX_VALUE);
            actual = this.memory.readVolatileLong(this.object, this.addr + (long)i);
            Assert.assertEquals((long)Long.MAX_VALUE, (long)actual);
        }
    }

    @Test
    public void readVolatileDouble() {
        for (int i = (int)(-this.addr & 7L); i <= 64; i += 8) {
            double actual;
            if (this.onHeap == null) {
                this.memory.writeDouble(this.addr + (long)i, 1.0);
                actual = this.memory.readVolatileDouble(this.addr + (long)i);
                Assert.assertEquals((double)1.0, (double)actual, (double)1.0E-7f);
                continue;
            }
            this.memory.writeDouble(this.object, this.addr + (long)i, 1.0);
            actual = this.memory.readVolatileDouble(this.object, this.addr + (long)i);
            Assert.assertEquals((double)1.0, (double)actual, (double)1.0E-7f);
        }
    }

    @Test
    public void writeVolatileByte() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeVolatileByte(this.addr + (long)i, (byte)127);
                Assert.assertEquals((long)127L, (long)this.memory.readByte(this.addr + (long)i));
                continue;
            }
            this.memory.writeVolatileByte(this.object, this.addr + (long)i, (byte)127);
            Assert.assertEquals((long)127L, (long)this.memory.readByte(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void writeVolatileShort() {
        for (int i = 0; i <= 64; i += 2) {
            if (this.onHeap == null) {
                this.memory.writeVolatileShort(this.addr + (long)i, (short)Short.MAX_VALUE);
                Assert.assertEquals((long)32767L, (long)this.memory.readShort(this.addr + (long)i));
                continue;
            }
            this.memory.writeVolatileShort(this.object, this.addr + (long)i, (short)Short.MAX_VALUE);
            Assert.assertEquals((long)32767L, (long)this.memory.readShort(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void writeVolatileInt() {
        for (int i = 0; i <= 64; i += 4) {
            if (this.onHeap == null) {
                this.memory.writeVolatileInt(this.addr + (long)i, 305419896);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                continue;
            }
            this.memory.writeVolatileInt(this.object, this.addr + (long)i, 305419896);
            Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void writeVolatileFloat() {
        for (int i = 0; i <= 64; i += 4) {
            if (this.onHeap == null) {
                this.memory.writeVolatileFloat(this.addr + (long)i, 1.0f);
                Assert.assertEquals((float)1.0f, (float)this.memory.readFloat(this.addr + (long)i), (float)1.0E-7f);
                continue;
            }
            this.memory.writeVolatileFloat(this.object, this.addr + (long)i, 1.0f);
            Assert.assertEquals((float)1.0f, (float)this.memory.readFloat(this.object, this.addr + (long)i), (float)1.0E-7f);
        }
    }

    @Test
    public void writeVolatileLong() {
        for (int i = (int)(-this.addr & 7L); i <= 64; i += 8) {
            if (this.onHeap == null) {
                this.memory.writeVolatileLong(this.addr + (long)i, Long.MAX_VALUE);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.addr + (long)i));
                continue;
            }
            this.memory.writeVolatileLong(this.object, this.addr + (long)i, Long.MAX_VALUE);
            Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void writeVolatileDouble() {
        for (int i = (int)(-this.addr & 7L); i <= 64; i += 8) {
            if (this.onHeap == null) {
                this.memory.writeVolatileDouble(this.addr + (long)i, 1.0);
                Assert.assertEquals((double)1.0, (double)this.memory.readDouble(this.addr + (long)i), (double)1.0E-7f);
                continue;
            }
            this.memory.writeVolatileDouble(this.object, this.addr + (long)i, 1.0);
            Assert.assertEquals((double)1.0, (double)this.memory.readDouble(this.object, this.addr + (long)i), (double)1.0E-7f);
        }
    }

    @Test
    public void addInt() throws MisAlignedAssertionError {
        for (int i = 0; i <= 64; i += 4) {
            try {
                int actual;
                if (this.onHeap == null) {
                    this.memory.writeInt(this.addr + (long)i, 0);
                    actual = this.memory.addInt(this.addr + (long)i, 305419896);
                    Assert.assertEquals((long)305419896L, (long)actual);
                    Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                    continue;
                }
                this.memory.writeInt(this.object, this.addr + (long)i, 0);
                actual = this.memory.addInt(this.object, this.addr + (long)i, 305419896);
                Assert.assertEquals((long)305419896L, (long)actual);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
                continue;
            }
            catch (MisAlignedAssertionError e) {
                if (!this.memory.safeAlignedInt(this.addr + (long)i)) continue;
                throw e;
            }
        }
    }

    @Test
    public void addLong() throws MisAlignedAssertionError {
        for (int i = (int)(-this.addr & 7L); i <= 64; i += 8) {
            try {
                long actual;
                if (this.onHeap == null) {
                    this.memory.writeLong(this.addr + (long)i, 0L);
                    actual = this.memory.addLong(this.addr + (long)i, Long.MAX_VALUE);
                    Assert.assertEquals((long)Long.MAX_VALUE, (long)actual);
                    Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.addr + (long)i));
                    continue;
                }
                this.memory.writeLong(this.object, this.addr + (long)i, 0L);
                actual = this.memory.addLong(this.object, this.addr + (long)i, Long.MAX_VALUE);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)actual);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.object, this.addr + (long)i));
                continue;
            }
            catch (MisAlignedAssertionError e) {
                if (!this.memory.safeAlignedLong(this.addr + (long)i)) continue;
                throw e;
            }
        }
    }

    public static class TestObject {
        public int value;
    }

    private static class TestClass {
        boolean booleanField = false;
        double doubleField = 0.0;

        private TestClass() {
        }
    }
}

