/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.internal.ObjectHeaderSizeHolder;
import org.junit.Assert;
import org.junit.Test;
import sun.misc.Unsafe;

public class ObjectHeaderSizeHolderTest {
    @Test
    public void objectHeaderSize() {
        Assert.assertEquals((long)ObjectHeaderSizeHolder.getSize(), (long)Jvm.objectHeaderSize(this.getClass()));
        Assert.assertEquals((long)ObjectHeaderSizeHolder.getSize(), (long)Jvm.objectHeaderSize(String.class));
        Assert.assertEquals((long)Unsafe.ARRAY_BYTE_BASE_OFFSET, (long)Jvm.objectHeaderSize(byte[].class));
        Assert.assertEquals((long)Unsafe.ARRAY_LONG_BASE_OFFSET, (long)Jvm.objectHeaderSize(long[].class));
        Assert.assertEquals((long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET, (long)Jvm.objectHeaderSize(double[].class));
        Assert.assertEquals((long)Unsafe.ARRAY_OBJECT_BASE_OFFSET, (long)Jvm.objectHeaderSize(String[].class));
    }

    @Test
    public void getSizeShouldReturnPositiveValue() {
        int size = ObjectHeaderSizeHolder.getSize();
        Assert.assertTrue((String)"Object header size should be positive", (size > 0 ? 1 : 0) != 0);
    }

    @Test
    public void objectHeaderSizeShouldReturnPositiveForNonArrayClass() {
        int size = ObjectHeaderSizeHolder.objectHeaderSize(Object.class);
        Assert.assertTrue((String)"Object header size for non-array class should be positive", (size > 0 ? 1 : 0) != 0);
    }

    @Test
    public void objectHeaderSizeShouldReturnPositiveForArrayClass() {
        int size = ObjectHeaderSizeHolder.objectHeaderSize(int[].class);
        Assert.assertTrue((String)"Array base offset for array class should be non-negative", (size >= 0 ? 1 : 0) != 0);
    }
}

