/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.cleaner;

import java.nio.ByteBuffer;
import net.openhft.chronicle.core.cleaner.spi.ByteBufferCleanerService;
import net.openhft.chronicle.core.internal.cleaner.ReflectionBasedByteBufferCleanerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;

public class ReflectionBasedByteBufferCleanerServiceTest {
    private final ReflectionBasedByteBufferCleanerService cleanerService = new ReflectionBasedByteBufferCleanerService();

    @Test
    @EnabledIfSystemProperty(named="java.version", matches="1\\.8.*")
    public void cleanShouldWorkOnJava8() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
        Assertions.assertDoesNotThrow(() -> this.cleanerService.clean(buffer), (String)"Cleaning a direct buffer should not throw an exception on Java 8");
    }

    @Test
    @EnabledIfSystemProperty(named="java.version", matches="9|1[0-9].*")
    public void cleanShouldWorkOnJava9Plus() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
        Assertions.assertDoesNotThrow(() -> this.cleanerService.clean(buffer), (String)"Cleaning a direct buffer should not throw an exception on Java 9+");
    }

    @Test
    public void impactShouldReturnValidImpact() {
        ByteBufferCleanerService.Impact impact = this.cleanerService.impact();
        Assertions.assertTrue((impact == ByteBufferCleanerService.Impact.SOME_IMPACT || impact == ByteBufferCleanerService.Impact.UNAVAILABLE ? 1 : 0) != 0, (String)"Impact should be either SOME_IMPACT or UNAVAILABLE");
    }
}

