/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import org.junit.Assert;
import org.junit.Assume;

public class BackgroundResourceReleaserMain {
    private final AtomicLong closed = new AtomicLong();
    private final AtomicLong released = new AtomicLong();

    public static void main(String[] args) throws Throwable {
        try {
            switch (args[0]) {
                case "stop": {
                    new BackgroundResourceReleaserMain().runResourcesCleanedUpAndStopped();
                    break;
                }
                case "manual": {
                    new BackgroundResourceReleaserMain().runResourcesCleanedUpManually();
                    break;
                }
                case "foreground": {
                    new BackgroundResourceReleaserMain().runResourcesCleanedUpInForeground();
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw th;
        }
    }

    public void runResourcesCleanedUpManually() throws IllegalAccessException {
        Assume.assumeTrue((boolean)BackgroundResourceReleaser.BG_RELEASER);
        Assert.assertNull((Object)this.getReleaserThread());
        int count = 20;
        for (int i = 1; i < count; ++i) {
            new BGCloseable().close();
            new BGReferenceCounted().releaseLast();
        }
        Assert.assertEquals((float)2.0f, (float)this.closed.get(), (float)2.0f);
        Assert.assertEquals((float)2.0f, (float)this.released.get(), (float)2.0f);
        BGCloseable bgc = new BGCloseable();
        bgc.close();
        Assert.assertTrue((boolean)bgc.isClosing());
        Assert.assertFalse((boolean)bgc.isClosed());
        BGReferenceCounted bgr = new BGReferenceCounted();
        bgr.releaseLast();
        Assert.assertEquals((long)0L, (long)bgr.refCount());
        WaitingCloseable wc = new WaitingCloseable();
        new Thread(() -> ((WaitingCloseable)wc).close()).start();
        wc.close();
        Assert.assertNotEquals((long)count, (long)this.closed.get());
        Assert.assertNotEquals((long)count, (long)this.released.get());
        BackgroundResourceReleaser.releasePendingResources();
        Assert.assertEquals((long)count, (long)this.closed.get());
        Assert.assertEquals((long)count, (long)this.released.get());
        AbstractCloseable.assertCloseablesClosed();
        BackgroundResourceReleaser.releasePendingResources();
    }

    public void runResourcesCleanedUpAndStopped() throws IllegalAccessException {
        Assume.assumeTrue((boolean)BackgroundResourceReleaser.BG_RELEASER);
        Assert.assertNotNull((Object)this.getReleaserThread());
        int count = 20;
        for (int i = 1; i < count; ++i) {
            new BGCloseable().close();
            new BGReferenceCounted().releaseLast();
        }
        Assert.assertEquals((float)2.0f, (float)this.closed.get(), (float)2.0f);
        Assert.assertEquals((float)2.0f, (float)this.released.get(), (float)2.0f);
        BGCloseable bgc = new BGCloseable();
        bgc.close();
        Assert.assertTrue((boolean)bgc.isClosing());
        Assert.assertFalse((boolean)bgc.isClosed());
        BGReferenceCounted bgr = new BGReferenceCounted();
        bgr.releaseLast();
        Assert.assertEquals((long)0L, (long)bgr.refCount());
        WaitingCloseable wc = new WaitingCloseable();
        new Thread(() -> ((WaitingCloseable)wc).close()).start();
        wc.close();
        BackgroundResourceReleaser.stop();
        Assert.assertEquals((long)count, (long)this.closed.get());
        Assert.assertEquals((long)count, (long)this.released.get());
        AbstractCloseable.assertCloseablesClosed();
        BackgroundResourceReleaser.stop();
        for (int i = 1; i < 1000; i += i) {
            if (!this.getReleaserThread().isAlive()) {
                return;
            }
            Jvm.pause((long)i);
        }
        Assert.fail((String)"Resource releaser thread did not terminate.");
    }

    public void runResourcesCleanedUpInForeground() throws IllegalAccessException {
        Assume.assumeFalse((boolean)BackgroundResourceReleaser.BG_RELEASER);
        Assert.assertNull((Object)this.getReleaserThread());
        int count = 20;
        for (int i = 1; i < count; ++i) {
            new BGCloseable().close();
            new BGReferenceCounted().releaseLast();
        }
        Assert.assertEquals((float)(count - 1), (float)this.closed.get(), (float)1.0f);
        Assert.assertEquals((float)(count - 1), (float)this.released.get(), (float)1.0f);
        BGCloseable bgc = new BGCloseable();
        bgc.close();
        Assert.assertTrue((boolean)bgc.isClosing());
        Assert.assertTrue((boolean)bgc.isClosed());
        BGReferenceCounted bgr = new BGReferenceCounted();
        bgr.releaseLast();
        Assert.assertEquals((long)0L, (long)bgr.refCount());
        WaitingCloseable wc = new WaitingCloseable();
        new Thread(() -> ((WaitingCloseable)wc).close()).start();
        wc.close();
        Assert.assertEquals((long)count, (long)this.closed.get());
        Assert.assertEquals((long)count, (long)this.released.get());
        BackgroundResourceReleaser.releasePendingResources();
        Assert.assertEquals((long)count, (long)this.closed.get());
        Assert.assertEquals((long)count, (long)this.released.get());
        AbstractCloseable.assertCloseablesClosed();
    }

    private Thread getReleaserThread() throws IllegalAccessException {
        return (Thread)Jvm.getField(BackgroundResourceReleaser.class, (String)"RELEASER").get(null);
    }

    class BGReferenceCounted
    extends AbstractReferenceCounted {
        BGReferenceCounted() {
        }

        protected boolean canReleaseInBackground() {
            return true;
        }

        protected void performRelease() {
            BackgroundResourceReleaserMain.this.released.incrementAndGet();
            Jvm.pause((long)10L);
        }
    }

    class BGCloseable
    extends AbstractCloseable {
        BGCloseable() {
        }

        protected boolean shouldPerformCloseInBackground() {
            return true;
        }

        protected void performClose() {
            BackgroundResourceReleaserMain.this.closed.incrementAndGet();
            Jvm.pause((long)10L);
        }
    }

    static class WaitingCloseable
    extends AbstractCloseable {
        WaitingCloseable() {
        }

        protected boolean shouldWaitForClosed() {
            return true;
        }

        protected void performClose() {
            Jvm.pause((long)10L);
        }
    }
}

