/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.BackgroundResourceReleaserMain;
import net.openhft.chronicle.testframework.process.JavaProcessBuilder;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class BackgroundResourceReleaserTest
extends CoreTestCommon {
    private final AtomicLong closed = new AtomicLong();
    private final AtomicLong released = new AtomicLong();

    @Test
    public void testResourcesCleanedUp() throws IllegalStateException {
        Assume.assumeTrue((boolean)BackgroundResourceReleaser.BG_RELEASER);
        int count = 20;
        for (int i = 1; i < count; ++i) {
            new BGCloseable().close();
            new BGReferenceCounted().releaseLast();
        }
        Assert.assertEquals((float)1.0f, (float)this.closed.get(), (float)1.0f);
        Assert.assertEquals((float)1.0f, (float)this.released.get(), (float)1.0f);
        BGCloseable bgc = new BGCloseable();
        bgc.close();
        Assert.assertTrue((boolean)bgc.isClosing());
        Assert.assertFalse((boolean)bgc.isClosed());
        BGReferenceCounted bgr = new BGReferenceCounted();
        bgr.releaseLast();
        Assert.assertEquals((long)0L, (long)bgr.refCount());
        long start0 = System.currentTimeMillis();
        WaitingCloseable wc = new WaitingCloseable();
        new Thread(() -> ((WaitingCloseable)wc).close()).start();
        wc.close();
        long time0 = System.currentTimeMillis() - start0;
        int error = Jvm.isAzulZing() || Jvm.isAzulZulu() || Jvm.isMacArm() ? 45 : (Jvm.isArm() || OS.isWindows() ? 16 : 12);
        BackgroundResourceReleaserTest.assertBetween(10L, time0, 20 + 3 * error);
        BackgroundResourceReleaser.releasePendingResources();
        long time = System.currentTimeMillis() - start0;
        int factor = count * (Jvm.isAzulZulu() || OS.isMacOSX() ? 80 : (OS.isWindows() ? 20 : 18));
        BackgroundResourceReleaserTest.assertBetween(count * 9, time, factor);
        Assert.assertEquals((long)count, (long)this.closed.get());
        Assert.assertEquals((long)count, (long)this.released.get());
        AbstractCloseable.assertCloseablesClosed();
    }

    @Test
    public void testResourcesCleanedUpManually() throws IllegalStateException, IOException, InterruptedException {
        Process process = JavaProcessBuilder.create(BackgroundResourceReleaserMain.class).withJvmArguments(new String[]{"-Dbackground.releaser.thread=false"}).withProgramArguments(new String[]{"manual"}).start();
        try {
            Assert.assertEquals((long)0L, (long)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"BackgroundResourceReleaserMain manual", (Process)process);
        }
    }

    @Test
    public void testResourcesCleanedUpAndThreadStopped() throws IllegalStateException, IOException, InterruptedException {
        Process process = JavaProcessBuilder.create(BackgroundResourceReleaserMain.class).withProgramArguments(new String[]{"stop"}).start();
        try {
            Assert.assertEquals((long)0L, (long)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"BackgroundResourceReleaserMain stop", (Process)process);
        }
    }

    @Test
    public void testResourcesCleanedUpInForeground() throws IllegalStateException, IOException, InterruptedException {
        Process process = JavaProcessBuilder.create(BackgroundResourceReleaserMain.class).withJvmArguments(new String[]{"-Dbackground.releaser=false"}).withProgramArguments(new String[]{"foreground"}).start();
        try {
            Assert.assertEquals((long)0L, (long)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"BackgroundResourceReleaserMain stop", (Process)process);
        }
    }

    @Test
    public void isOnBackgroundResourceReleaserThreadIsTrueWhenOnThread() {
        Assume.assumeTrue((boolean)BackgroundResourceReleaser.BG_RELEASER);
        WasInBackgroundResourceReleaserRecorder recorder = new WasInBackgroundResourceReleaserRecorder(true);
        recorder.close();
        this.assertValueBecomes(true, recorder::wasClosedInBackgroundResourceReleaserThread);
        Assert.assertTrue((boolean)recorder.wasClosedInBackgroundResourceReleaserThread());
    }

    @Test
    public void isOnBackgroundResourceReleaserThreadIsFalseWhenNotOnThread() {
        WasInBackgroundResourceReleaserRecorder recorder = new WasInBackgroundResourceReleaserRecorder(false);
        recorder.close();
        this.assertValueBecomes(false, recorder::wasClosedInBackgroundResourceReleaserThread);
        Assert.assertFalse((boolean)recorder.wasClosedInBackgroundResourceReleaserThread());
    }

    private void assertValueBecomes(boolean expectedValue, Supplier<Boolean> supplier) {
        long endTime = System.currentTimeMillis() + 5000L;
        while (supplier.get() == null) {
            Jvm.pause((long)10L);
            if (System.currentTimeMillis() <= endTime) continue;
            Assert.fail((String)"Timed out waiting for value");
        }
        Assert.assertEquals((Object)expectedValue, (Object)supplier.get());
    }

    static void assertBetween(long min, long actual, long max) {
        if (min <= actual && actual <= max) {
            return;
        }
        throw new AssertionError((Object)("Not in range " + min + " <= " + actual + " <= " + max));
    }

    class BGReferenceCounted
    extends AbstractReferenceCounted {
        BGReferenceCounted() {
        }

        protected boolean canReleaseInBackground() {
            return true;
        }

        protected void performRelease() {
            BackgroundResourceReleaserTest.this.released.incrementAndGet();
            Jvm.pause((long)10L);
        }
    }

    class BGCloseable
    extends AbstractCloseable {
        BGCloseable() {
        }

        protected boolean shouldPerformCloseInBackground() {
            return true;
        }

        protected void performClose() {
            BackgroundResourceReleaserTest.this.closed.incrementAndGet();
            Jvm.pause((long)10L);
        }
    }

    static class WaitingCloseable
    extends AbstractCloseable {
        WaitingCloseable() {
        }

        protected boolean shouldWaitForClosed() {
            return true;
        }

        protected void performClose() {
            Jvm.pause((long)10L);
        }
    }

    private static class WasInBackgroundResourceReleaserRecorder
    extends AbstractCloseable {
        private final boolean shouldPerformCloseInBackground;
        private Boolean wasClosedInBackgroundResourceReleaserThread = null;

        public WasInBackgroundResourceReleaserRecorder(boolean shouldPerformCloseInBackground) {
            this.shouldPerformCloseInBackground = shouldPerformCloseInBackground;
        }

        protected boolean shouldPerformCloseInBackground() {
            return this.shouldPerformCloseInBackground;
        }

        protected void performClose() {
            this.wasClosedInBackgroundResourceReleaserThread = BackgroundResourceReleaser.isOnBackgroundResourceReleaserThread();
        }

        public Boolean wasClosedInBackgroundResourceReleaserThread() {
            return this.wasClosedInBackgroundResourceReleaserThread;
        }
    }
}

