/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.core.io.CleaningRandomAccessFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CleaningRandomAccessFileTest {
    @Test
    public void testOpenAndClose() throws IOException {
        File tempFile = File.createTempFile("test", "raf");
        CleaningRandomAccessFile raf = new CleaningRandomAccessFile(tempFile, "rw");
        raf.writeUTF("test");
        raf.seek(0L);
        Assertions.assertEquals((Object)"test", (Object)raf.readUTF());
        raf.close();
        Assertions.assertThrows(IOException.class, () -> raf.writeUTF("should fail"));
        Assertions.assertTrue((boolean)tempFile.delete());
    }

    @Test
    public void testFinalizeAndCleanup() throws IOException {
        File tempFile = File.createTempFile("test", "raf");
        new CleaningRandomAccessFile(tempFile, "rw");
        System.gc();
        System.runFinalization();
        Assertions.assertTrue((boolean)tempFile.delete());
    }
}

