/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.IOException;
import net.openhft.chronicle.core.io.ClosedIORuntimeException;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IORuntimeExceptionTest {
    @Test
    public void testConstructorWithMessage() {
        String message = "Error message";
        IORuntimeException exception = new IORuntimeException(message);
        Assertions.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithThrowable() {
        IOException cause = new IOException("Cause");
        IORuntimeException exception = new IORuntimeException((Throwable)cause);
        Assertions.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    public void testConstructorWithMessageAndThrowable() {
        String message = "Error message";
        IOException cause = new IOException("Cause");
        IORuntimeException exception = new IORuntimeException(message, (Throwable)cause);
        Assertions.assertEquals((Object)message, (Object)exception.getMessage());
        Assertions.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    public void testNewIORuntimeException() {
        IOException closedException = new IOException("Connection reset by peer");
        IOException otherException = new IOException("Some other IO error");
        IORuntimeException runtimeClosedException = IORuntimeException.newIORuntimeException((Exception)closedException);
        IORuntimeException runtimeOtherException = IORuntimeException.newIORuntimeException((Exception)otherException);
        Assertions.assertTrue((boolean)(runtimeClosedException instanceof ClosedIORuntimeException));
        Assertions.assertEquals((Object)closedException, (Object)runtimeClosedException.getCause());
        Assertions.assertFalse((boolean)(runtimeOtherException instanceof ClosedIORuntimeException));
        Assertions.assertEquals((Object)otherException, (Object)runtimeOtherException.getCause());
    }
}

