/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.stream.IntStream;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.cleaner.impl.CleanerTestUtil;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class IOToolsTest
extends CoreTestCommon {
    @Test
    public void testIsClosedException() {
        IOException closedConnectionException = new IOException("Connection reset by peer");
        Assert.assertTrue((boolean)IOTools.isClosedException((Exception)closedConnectionException));
        IOException otherException = new IOException("Some other IO error");
        Assert.assertFalse((boolean)IOTools.isClosedException((Exception)otherException));
    }

    @Test
    public void testWriteFile() throws IOException {
        String testFilename = "testFile.tmp";
        String testData = "Test Data";
        IOTools.writeFile((String)testFilename, (byte[])testData.getBytes());
        Path path = Paths.get(testFilename, new String[0]);
        Assert.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Assert.assertArrayEquals((byte[])testData.getBytes(), (byte[])Files.readAllBytes(path));
        Files.deleteIfExists(path);
    }

    @Test
    public void testTempName() {
        String filename = "test.txt";
        String tempFilename = IOTools.tempName((String)filename);
        Assert.assertNotEquals((Object)filename, (Object)tempFilename);
        Assert.assertTrue((boolean)tempFilename.startsWith("test"));
        Assert.assertTrue((boolean)tempFilename.endsWith(".txt"));
    }

    @Test
    public void testClean() {
        ByteBuffer bb = ByteBuffer.allocateDirect(1024);
        IOTools.clean((ByteBuffer)bb);
    }

    @Test
    public void testCreateDirectories() throws IOException {
        Path tempDir = Paths.get("tempDir", new String[0]);
        IOTools.createDirectories((Path)tempDir);
        Assert.assertTrue((boolean)Files.isDirectory(tempDir, new LinkOption[0]));
        Files.deleteIfExists(tempDir);
    }

    @Test
    public void testIsDirectBuffer() {
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(1024);
        ByteBuffer nonDirectBuffer = ByteBuffer.allocate(1024);
        Assert.assertTrue((boolean)IOTools.isDirectBuffer((ByteBuffer)directBuffer));
        Assert.assertFalse((boolean)IOTools.isDirectBuffer((ByteBuffer)nonDirectBuffer));
    }

    @Test
    public void testAddressFor() {
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(1024);
        long address = IOTools.addressFor((ByteBuffer)directBuffer);
        Assert.assertNotEquals((long)0L, (long)address);
    }

    @Test
    public void testDeleteDirWithFiles() throws IOException {
        Path tempDir = Files.createTempDirectory("testDir", new FileAttribute[0]);
        File tempFile = Files.createTempFile(tempDir, "test", ".tmp", new FileAttribute[0]).toFile();
        Assert.assertTrue((boolean)tempFile.exists());
        Assert.assertTrue((boolean)IOTools.deleteDirWithFiles((File)tempDir.toFile()));
        Assert.assertFalse((boolean)tempFile.exists());
        Assert.assertFalse((boolean)tempDir.toFile().exists());
    }

    @Test
    public void testReadAsBytes() throws IOException {
        String testData = "Test Data";
        ByteArrayInputStream bais = new ByteArrayInputStream(testData.getBytes());
        byte[] bytes = IOTools.readAsBytes((InputStream)bais);
        Assert.assertArrayEquals((byte[])testData.getBytes(), (byte[])bytes);
    }

    @Test
    public void readFileManyTimesByPath() {
        int iterations = 3000;
        LongAccumulator accumulator = new LongAccumulator(Long::sum, 0L);
        IntStream.range(0, 3000).parallel().forEach(i -> {
            try {
                IOTools.readFile(IOToolsTest.class, (String)"readFileManyTimes.txt");
                accumulator.accumulate(1L);
            }
            catch (IOException ioe) {
                Jvm.rethrow((Throwable)ioe);
            }
        });
        Assert.assertEquals((long)3000L, (long)accumulator.get());
    }

    @Test
    public void readFileManyTimesByFile() throws IOException {
        int iterations = 3000;
        LongAccumulator accumulator = new LongAccumulator(Long::sum, 0L);
        String file = OS.getTarget() + "/readFileManyTimes.txt";
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write("Delete me\n".getBytes(StandardCharsets.UTF_8));
        }
        IntStream.range(0, 3000).parallel().forEach(i -> {
            try {
                IOTools.readFile(IOToolsTest.class, (String)file);
                accumulator.accumulate(1L);
            }
            catch (IOException ioe) {
                Jvm.rethrow((Throwable)ioe);
            }
        });
        Assert.assertEquals((long)3000L, (long)accumulator.get());
    }

    @Test
    public void shouldCleanDirectBuffer() {
        CleanerTestUtil.test(IOTools::clean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createDirectoriesWithBrokenLink() throws IOException, IllegalStateException {
        Assume.assumeTrue((boolean)OS.isLinux());
        String path = OS.getTarget();
        Path link = Paths.get(path, "link2nowhere" + Time.uniqueId());
        Path nowhere = Paths.get(path, "nowhere");
        if (Files.isSymbolicLink(link)) {
            Files.delete(link);
            if (Files.isSymbolicLink(link)) {
                throw new IllegalStateException("Still exists");
            }
        }
        Files.createSymbolicLink(link, nowhere, new FileAttribute[0]);
        try {
            IOTools.createDirectories((Path)Paths.get(link.toString(), "subdir" + Time.uniqueId()));
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertSame(IOException.class, ioe.getClass());
            Assert.assertTrue((boolean)ioe.getMessage().startsWith("Symbolic link from "));
            Assert.assertTrue((boolean)ioe.getMessage().endsWith("nowhere is broken"));
        }
        finally {
            Files.delete(link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createDirectoriesReadOnly() throws IOException, IllegalStateException {
        Assume.assumeTrue((boolean)OS.isLinux());
        String path = OS.getTarget();
        Path ro = Paths.get(path, "read-only" + Time.uniqueId());
        IOTools.createDirectories((Path)ro);
        if (!ro.toFile().setWritable(false)) {
            throw new IllegalStateException("Cannot make read-only");
        }
        Assert.assertFalse((boolean)ro.toFile().canWrite());
        try {
            IOTools.createDirectories((Path)Paths.get(ro.toString(), "subdir" + Time.uniqueId()));
        }
        catch (IOException ioe) {
            Assert.assertSame(IOException.class, ioe.getClass());
            Assert.assertTrue((boolean)ioe.getMessage().startsWith("Cannot write to "));
        }
        finally {
            if (!ro.toFile().setWritable(true)) {
                throw new IllegalStateException("Cannot make read-write");
            }
            Files.delete(ro);
        }
    }

    @Test
    public void cannotTurnAfileIntoADirectory() throws IOException {
        Assume.assumeTrue((boolean)OS.isLinux());
        String path = OS.getTarget();
        Path file = Paths.get(path, "test-file" + Time.uniqueId());
        file.toFile().delete();
        file.toFile().deleteOnExit();
        Assert.assertTrue((boolean)file.toFile().createNewFile());
        try {
            IOTools.createDirectories((Path)Paths.get(file.toString(), "subdir" + Time.uniqueId()));
        }
        catch (IOException ioe) {
            Assert.assertSame(IOException.class, ioe.getClass());
            Assert.assertTrue((boolean)ioe.getMessage().startsWith("Cannot create a directory with the same name as a file "));
        }
    }

    @Test
    public void isDirectBuffer() {
        Assert.assertTrue((boolean)IOTools.isDirectBuffer((ByteBuffer)ByteBuffer.allocateDirect(1)));
        Assert.assertFalse((boolean)IOTools.isDirectBuffer((ByteBuffer)ByteBuffer.allocate(1)));
    }

    @Test
    public void addressFor() {
        Assert.assertNotEquals((long)0L, (long)IOTools.addressFor((ByteBuffer)ByteBuffer.allocateDirect(1)));
    }

    @Test
    public void addressFor2() {
        ByteBuffer bb = ByteBuffer.allocate(1);
        try {
            IOTools.addressFor((ByteBuffer)bb);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void normaliseIOStatus() {
        int actual = -3;
        Assert.assertEquals((long)-3L, (long)-3L);
        Assert.assertEquals((long)-3L, (long)IOTools.normaliseIOStatus((int)-3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectionClosed() throws IOException {
        ServerSocket ss = new ServerSocket(0);
        Socket s = new Socket("localhost", ss.getLocalPort());
        OutputStream os = s.getOutputStream();
        Socket s2 = ss.accept();
        s2.close();
        ss.close();
        byte[] bytes = new byte[512];
        try {
            for (int i = 0; i < 100; ++i) {
                os.write(bytes);
            }
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)ioe.toString(), (boolean)IOTools.isClosedException((Exception)ioe));
        }
        finally {
            os.close();
        }
        try {
            s2.getOutputStream().write(bytes);
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)ioe.toString(), (boolean)IOTools.isClosedException((Exception)ioe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectionClosed2() throws IOException {
        ServerSocket ss = new ServerSocket(0);
        SocketChannel sc = SocketChannel.open(new InetSocketAddress("localhost", ss.getLocalPort()));
        Socket s2 = ss.accept();
        s2.close();
        ByteBuffer bytes = ByteBuffer.allocateDirect(1024);
        try {
            OutputStream os = s2.getOutputStream();
            os.close();
            os.write(1);
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)ioe.toString(), (boolean)IOTools.isClosedException((Exception)ioe));
        }
        ss.close();
        try {
            for (int i = 0; i < 100; ++i) {
                bytes.clear();
                sc.write(bytes);
            }
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)ioe.toString(), (boolean)IOTools.isClosedException((Exception)ioe));
        }
        finally {
            sc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectionClosed3() throws IOException {
        ServerSocket ss = new ServerSocket(0);
        SocketChannel sc = SocketChannel.open(new InetSocketAddress("localhost", ss.getLocalPort()));
        Socket s2 = ss.accept();
        ss.close();
        ByteBuffer bytes = ByteBuffer.allocateDirect(1024);
        Thread t = new Thread(() -> {
            Jvm.pause((long)100L);
            try {
                sc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "close~thread");
        t.start();
        try {
            for (int i = 0; i < 10000; ++i) {
                bytes.clear();
                int write = sc.write(bytes);
                Assert.assertTrue((write > 0 ? 1 : 0) != 0);
            }
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)ioe.toString(), (boolean)IOTools.isClosedException((Exception)ioe));
        }
        finally {
            s2.close();
            sc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectionClosed4() throws IOException {
        ServerSocket ss = new ServerSocket(0);
        SocketChannel sc = SocketChannel.open(new InetSocketAddress("localhost", ss.getLocalPort()));
        Socket s2 = ss.accept();
        ss.close();
        ByteBuffer bytes = ByteBuffer.allocateDirect(1024);
        Thread main = Thread.currentThread();
        Thread t = new Thread(() -> {
            Jvm.pause((long)100L);
            main.interrupt();
            Jvm.pause((long)10L);
            try {
                sc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "close~thread");
        t.setDaemon(true);
        t.start();
        try {
            for (int i = 0; i < 10000; ++i) {
                bytes.clear();
                int write = sc.write(bytes);
                Assert.assertTrue((write > 0 ? 1 : 0) != 0);
            }
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)ioe.toString(), (boolean)IOTools.isClosedException((Exception)ioe));
        }
        finally {
            s2.close();
            sc.close();
        }
    }
}

