/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ManagedCloseable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ManagedCloseableTest {
    @BeforeEach
    public void mockitoNotSupportedOnJava21() {
        Assumptions.assumeTrue((Jvm.majorVersion() <= 17 ? 1 : 0) != 0);
    }

    @Test
    public void testWarnAndCloseIfNotClosed() {
        ManagedCloseable closeable = (ManagedCloseable)Mockito.spy(ManagedCloseable.class);
        Mockito.when((Object)closeable.isClosing()).thenReturn((Object)false);
        closeable.warnAndCloseIfNotClosed();
        ((ManagedCloseable)Mockito.verify((Object)closeable, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testThrowExceptionIfClosed() {
        ManagedCloseable closeable = (ManagedCloseable)Mockito.spy(ManagedCloseable.class);
        Mockito.when((Object)closeable.isClosing()).thenReturn((Object)true);
        Mockito.when((Object)closeable.isClosed()).thenReturn((Object)true);
        Assertions.assertThrows(ClosedIllegalStateException.class, () -> ((ManagedCloseable)closeable).throwExceptionIfClosed());
    }

    @Test
    public void testCreatedHere() {
        ManagedCloseable closeable = (ManagedCloseable)Mockito.spy(ManagedCloseable.class);
        Assertions.assertNull((Object)closeable.createdHere());
    }
}

