/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.ReferenceChangeListener;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.SingleThreadedChecked;
import org.junit.Assert;
import org.junit.Test;

public abstract class ReferenceCountedContractTest
extends CoreTestCommon {
    protected abstract ReferenceCounted createReferenceCounted();

    @Override
    protected void assertReferencesReleased() {
    }

    @Test
    public void reserveWillIncrementReferenceCount() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        Assert.assertEquals((long)1L, (long)referenceCounted.refCount());
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        referenceCounted.reserve(a);
        Assert.assertEquals((long)2L, (long)referenceCounted.refCount());
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        referenceCounted.reserve(b);
        Assert.assertEquals((long)3L, (long)referenceCounted.refCount());
    }

    @Test
    public void reserveWillFailWhenResourceIsAlreadyReleased() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        referenceCounted.releaseLast();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        Assert.assertThrows(IllegalStateException.class, () -> referenceCounted.reserve(a));
    }

    @Test
    public void reserveTransferWillNotChangeReferenceCount() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        referenceCounted.reserve(a);
        Assert.assertEquals((long)2L, (long)referenceCounted.refCount());
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        referenceCounted.reserveTransfer(a, b);
        Assert.assertEquals((long)2L, (long)referenceCounted.refCount());
    }

    @Test
    public void releaseWillDecrementReferenceCount() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        Assert.assertEquals((long)1L, (long)referenceCounted.refCount());
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        referenceCounted.reserve(a);
        Assert.assertEquals((long)2L, (long)referenceCounted.refCount());
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        referenceCounted.reserve(b);
        Assert.assertEquals((long)3L, (long)referenceCounted.refCount());
        referenceCounted.release(b);
        Assert.assertEquals((long)2L, (long)referenceCounted.refCount());
        referenceCounted.release(a);
        Assert.assertEquals((long)1L, (long)referenceCounted.refCount());
    }

    @Test
    public void releaseWillFailWhenResourceAlreadyReleased() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        referenceCounted.releaseLast();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        Assert.assertThrows(IllegalStateException.class, () -> referenceCounted.release(a));
    }

    @Test
    public void releaseWillGoAllTheWayToZero() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        referenceCounted.release(ReferenceOwner.INIT);
        Assert.assertEquals((long)0L, (long)referenceCounted.refCount());
    }

    @Test
    public void releaseLastWillDecrementReferenceCount() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        Assert.assertEquals((long)1L, (long)referenceCounted.refCount());
        referenceCounted.releaseLast();
        Assert.assertEquals((long)0L, (long)referenceCounted.refCount());
    }

    @Test
    public void releaseLastWillReleaseThenFailWhenReferenceIsNotLast() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        referenceCounted.reserve(a);
        Assert.assertEquals((long)2L, (long)referenceCounted.refCount());
        Assert.assertThrows(IllegalStateException.class, () -> ((ReferenceCounted)referenceCounted).releaseLast());
        Assert.assertEquals((long)1L, (long)referenceCounted.refCount());
        referenceCounted.releaseLast(a);
    }

    @Test
    public void releaseLastWillFailWhenResourceAlreadyReleased() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        referenceCounted.releaseLast();
        Assert.assertThrows(IllegalStateException.class, () -> ((ReferenceCounted)referenceCounted).releaseLast());
    }

    @Test
    public void tryReserveWillReturnTrueWhenReservationWasSuccessful() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        Assert.assertTrue((boolean)referenceCounted.tryReserve(a));
    }

    @Test
    public void tryReserveWillReturnFalseWhenResourceIsAlreadyReleased() {
        ReferenceCounted referenceCounted = this.createReferenceCounted();
        referenceCounted.releaseLast();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        Assert.assertFalse((boolean)referenceCounted.tryReserve(a));
    }

    @Test
    public void implementationsShouldBeThreadSafe() throws InterruptedException {
        int numThreads = Math.max(3, Math.min(6, Runtime.getRuntime().availableProcessors()));
        int numReferences = 10;
        AtomicBoolean running = new AtomicBoolean(true);
        ReferenceCounted counted = this.createReferenceCounted();
        if (counted instanceof SingleThreadedChecked) {
            ((SingleThreadedChecked)counted).singleThreadedCheckDisabled(true);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        List<Future> futures = IntStream.range(0, numThreads).mapToObj(i -> executorService.submit(new ResourceGetter(i, numReferences, running, counted))).collect(Collectors.toList());
        Jvm.pause((long)500L);
        running.set(false);
        futures.forEach(this::getQuietly);
        executorService.shutdown();
        if (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("ExecutorService didn't shut down");
        }
        counted.releaseLast();
    }

    @Test
    public void shouldNotifyListenersWhenReferencesAreAddedAndRemoved() {
        ReferenceCounted rc = this.createReferenceCounted();
        Assert.assertEquals((long)1L, (long)rc.refCount());
        final HashSet currentOwners = new HashSet();
        final HashSet untrackedOwners = new HashSet();
        rc.addReferenceChangeListener(new ReferenceChangeListener(){

            public void onReferenceAdded(ReferenceCounted referenceCounted, ReferenceOwner referenceOwner) {
                currentOwners.add(referenceOwner);
            }

            public void onReferenceRemoved(ReferenceCounted referenceCounted, ReferenceOwner referenceOwner) {
                if (!currentOwners.remove(referenceOwner)) {
                    untrackedOwners.add(referenceOwner);
                }
            }

            public void onReferenceTransferred(ReferenceCounted referenceCounted, ReferenceOwner fromOwner, ReferenceOwner toOwner) {
                currentOwners.remove(fromOwner);
                currentOwners.add(toOwner);
            }
        });
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        rc.reserve(a);
        Assert.assertEquals((long)1L, (long)currentOwners.size());
        Assert.assertTrue((boolean)currentOwners.contains(a));
        rc.reserve(b);
        Assert.assertEquals((long)2L, (long)currentOwners.size());
        Assert.assertTrue((boolean)currentOwners.contains(b));
        rc.release(a);
        Assert.assertEquals((long)1L, (long)currentOwners.size());
        Assert.assertTrue((boolean)currentOwners.contains(b));
        rc.reserveTransfer(b, a);
        Assert.assertEquals((long)1L, (long)currentOwners.size());
        Assert.assertTrue((boolean)currentOwners.contains(a));
        rc.release(a);
        Assert.assertEquals((long)0L, (long)currentOwners.size());
        rc.releaseLast(ReferenceOwner.INIT);
        Assert.assertEquals((long)1L, (long)untrackedOwners.size());
        Assert.assertFalse((boolean)currentOwners.contains(ReferenceOwner.INIT));
    }

    @Test
    public void whenAReferenceIsAddedTheReferenceChangeListenerShouldFire() {
        ReferenceCounted rc = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        CounterReferenceChangeListener referenceChangeListener = new CounterReferenceChangeListener();
        rc.addReferenceChangeListener((ReferenceChangeListener)referenceChangeListener);
        rc.reserve(a);
        Assert.assertEquals((long)1L, (long)referenceChangeListener.referenceAddedCount);
    }

    @Test
    public void whenAReferenceIsRemovedTheReferenceChangeListenerShouldFire() {
        ReferenceCounted rc = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        CounterReferenceChangeListener referenceChangeListener = new CounterReferenceChangeListener();
        rc.addReferenceChangeListener((ReferenceChangeListener)referenceChangeListener);
        rc.reserve(a);
        rc.release(a);
        Assert.assertEquals((long)1L, (long)referenceChangeListener.referenceRemovedCount);
    }

    @Test
    public void referenceChangeListenerShouldFireWhenAReferenceIsTransferred() {
        ReferenceCounted rc = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        CounterReferenceChangeListener referenceChangeListener = new CounterReferenceChangeListener();
        rc.addReferenceChangeListener((ReferenceChangeListener)referenceChangeListener);
        rc.reserve(a);
        rc.reserveTransfer(a, b);
        Assert.assertEquals((long)1L, (long)referenceChangeListener.referenceTransferredCount);
    }

    @Test
    public void shouldBeAbleToAddAndRemoveListeners() {
        ReferenceCounted rc = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        CounterReferenceChangeListener listener1 = new CounterReferenceChangeListener();
        CounterReferenceChangeListener listener2 = new CounterReferenceChangeListener();
        rc.addReferenceChangeListener((ReferenceChangeListener)listener1);
        rc.reserve(a);
        Assert.assertEquals((long)1L, (long)listener1.referenceAddedCount);
        Assert.assertEquals((long)0L, (long)listener2.referenceAddedCount);
        rc.addReferenceChangeListener((ReferenceChangeListener)listener2);
        rc.reserve(b);
        Assert.assertEquals((long)2L, (long)listener1.referenceAddedCount);
        Assert.assertEquals((long)1L, (long)listener2.referenceAddedCount);
        rc.removeReferenceChangeListener((ReferenceChangeListener)listener1);
        rc.release(a);
        Assert.assertEquals((long)0L, (long)listener1.referenceRemovedCount);
        Assert.assertEquals((long)1L, (long)listener2.referenceRemovedCount);
        rc.removeReferenceChangeListener((ReferenceChangeListener)listener2);
        rc.release(b);
        Assert.assertEquals((long)0L, (long)listener1.referenceRemovedCount);
        Assert.assertEquals((long)1L, (long)listener2.referenceRemovedCount);
    }

    private void getQuietly(Future<?> future) {
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Jvm.error().on(ReferenceCountedContractTest.class, "Exception thrown by acquirer", (Throwable)e);
        }
    }

    private static class Reference
    implements ReferenceOwner {
        private final int owner;
        private final int index;
        private final ReferenceCounted resource;

        public Reference(int owner, int index, ReferenceCounted resource) {
            this.owner = owner;
            this.index = index;
            this.resource = resource;
            this.resource.reserve((ReferenceOwner)this);
        }

        public void release() {
            this.resource.release((ReferenceOwner)this);
        }

        public String referenceName() {
            return String.format("{id=%s, index=%s}", this.owner, this.index);
        }
    }

    private static class ResourceGetter
    implements Runnable {
        private final int id;
        private final AtomicBoolean running;
        private final ReferenceCounted resource;
        private final Reference[] references;

        private ResourceGetter(int id, int numReferences, AtomicBoolean running, ReferenceCounted resource) {
            this.id = id;
            this.references = new Reference[numReferences];
            this.running = running;
            this.resource = resource;
        }

        @Override
        public void run() {
            int acquired = 0;
            int released = 0;
            while (this.running.get()) {
                int i = ThreadLocalRandom.current().nextInt(this.references.length);
                if (this.references[i] == null) {
                    this.references[i] = new Reference(this.id, acquired, this.resource);
                    ++acquired;
                    continue;
                }
                this.references[i].release();
                this.references[i] = null;
                ++released;
            }
            for (Reference reference : this.references) {
                if (reference == null) continue;
                reference.release();
                ++released;
            }
            Jvm.startup().on(ResourceGetter.class, "Acquired " + acquired + ", released " + released);
        }
    }

    static class CounterReferenceChangeListener
    implements ReferenceChangeListener {
        int referenceAddedCount = 0;
        int referenceRemovedCount = 0;
        int referenceTransferredCount = 0;

        CounterReferenceChangeListener() {
        }

        public void onReferenceAdded(ReferenceCounted referenceCounted, ReferenceOwner referenceOwner) {
            ++this.referenceAddedCount;
        }

        public void onReferenceRemoved(ReferenceCounted referenceCounted, ReferenceOwner referenceOwner) {
            ++this.referenceRemovedCount;
        }

        public void onReferenceTransferred(ReferenceCounted referenceCounted, ReferenceOwner fromOwner, ReferenceOwner toOwner) {
            ++this.referenceTransferredCount;
        }
    }
}

