/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.openhft.chronicle.core.internal.CloseableUtils;
import net.openhft.chronicle.core.io.MonitorReferenceCountedContractTest;
import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.TracingReferenceCounted;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TracingReferenceCountedTest
extends MonitorReferenceCountedContractTest {
    private AtomicInteger onReleaseCallCount;

    @Before
    public void setUp() {
        this.onReleaseCallCount = new AtomicInteger(0);
    }

    protected TracingReferenceCounted createReferenceCounted() {
        return new TracingReferenceCounted(this.onReleaseCallCount::incrementAndGet, "uniqueId", TracingReferenceCounted.class);
    }

    @Test
    public void reserveWillThrowAndNotReserveWhenReferenceOwnerAttemptsToMakeASecondReservation() {
        TracingReferenceCounted referenceCounted = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        referenceCounted.reserve(a);
        Assert.assertEquals((long)2L, (long)referenceCounted.refCount());
        Assert.assertThrows(IllegalStateException.class, () -> referenceCounted.reserve(a));
        Assert.assertEquals((long)2L, (long)referenceCounted.refCount());
    }

    @Test
    public void releaseWillFailWhenResourceOwnerHasNoReservation() {
        TracingReferenceCounted referenceCounted = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        Assert.assertThrows(IllegalStateException.class, () -> referenceCounted.release(a));
    }

    @Test
    public void releaseLastWillThrowWithReferenceDetailsWhenReleaseIsNotLast() {
        TracingReferenceCounted referenceCounted = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        referenceCounted.reserve(a);
        try {
            referenceCounted.releaseLast(a);
            Assert.fail((String)"Release last should throw here");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"net.openhft.chronicle.core.io.TracingReferenceCounted still reserved [INIT]", (Object)e.getMessage());
            Assert.assertEquals((Object)"uniqueId main init INIT on main", (Object)e.getSuppressed()[0].getMessage());
        }
    }

    @Test
    public void releaseLastWillThrowWithSuppressedInnerFailuresWhenReleaseFails() {
        TracingReferenceCounted referenceCounted = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        try {
            referenceCounted.releaseLast(a);
            Assert.fail((String)"Release last should throw here");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"net.openhft.chronicle.core.io.TracingReferenceCounted still reserved [INIT]", (Object)e.getMessage());
            Assert.assertEquals((Object)"uniqueId main init INIT on main", (Object)e.getSuppressed()[0].getMessage());
            Assert.assertEquals((Object)"net.openhft.chronicle.core.io.TracingReferenceCounted not reserved by VanillaReferenceOwner{name='a'} closed=false", (Object)e.getSuppressed()[1].getMessage());
        }
    }

    @Test
    public void asStringWillIncludeReferenceCountedDetails() {
        TracingReferenceCounted referenceCounted = this.createReferenceCounted();
        Assert.assertTrue((boolean)Pattern.matches("TracingReferenceCounted@\\w+ refCount=1", CloseableUtils.asString((Object)referenceCounted)));
    }

    @Test
    public void asStringWillIncludeCloseableDetails() {
        class SomeCloseable
        implements QueryCloseable,
        ReferenceOwner {
            SomeCloseable() {
            }

            public boolean isClosed() {
                return false;
            }

            public String referenceName() {
                return "testCloseable";
            }
        }
        Assert.assertEquals((Object)"testCloseable closed=false", (Object)CloseableUtils.asString((Object)new SomeCloseable()));
    }

    @Test
    public void asStringRenderClassNameAndAddressForPojos() {
        class SomePlainObject {
            SomePlainObject() {
            }
        }
        Assert.assertTrue((boolean)Pattern.matches("SomePlainObject@\\w+", CloseableUtils.asString((Object)new SomePlainObject())));
    }

    @Test
    public void createdHereWillReturnCreatedStackTrace() {
        TracingReferenceCounted referenceCounted = this.createReferenceCounted();
        Assert.assertNotNull((Object)referenceCounted.createdHere());
    }

    @Test
    public void reserveTransferWillThrowWhenFromHasNoReservation() {
        TracingReferenceCounted referenceCounted = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        Assert.assertThrows(IllegalStateException.class, () -> referenceCounted.reserveTransfer(a, b));
    }

    @Test
    public void reserveTransferWillThrowWhenToAlreadyHasAReservation() {
        TracingReferenceCounted referenceCounted = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        referenceCounted.reserve(a);
        referenceCounted.reserve(b);
        Assert.assertThrows(IllegalStateException.class, () -> referenceCounted.reserveTransfer(a, b));
    }

    @Test
    public void reserveWillThrowWhenCalledWithSelf() {
        TracingReferenceCounted referenceCounted = this.createReferenceCounted();
        Assert.assertThrows(AssertionError.class, () -> referenceCounted.reserve((ReferenceOwner)referenceCounted));
    }
}

