/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.scoped;

import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.scoped.ScopedThreadLocal;
import net.openhft.chronicle.core.scoped.WeakReferenceScopedResource;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class WeakReferenceScopedResourceTest {
    private ScopedThreadLocal<AtomicLong> scopedThreadLocal;

    WeakReferenceScopedResourceTest() {
    }

    @BeforeEach
    void setUp() {
        this.scopedThreadLocal = new ScopedThreadLocal(AtomicLong::new, 3);
    }

    @Test
    void resourceIsCreatedPreAcquire() {
        WeakReferenceScopedResource sr = new WeakReferenceScopedResource(this.scopedThreadLocal, AtomicLong::new);
        Assert.assertNull((Object)sr.get());
        sr.preAcquire();
        Assert.assertNotNull((Object)sr.get());
    }

    @Test
    void strongReferenceIsCreatedPreAcquire() {
        WeakReferenceScopedResource sr = new WeakReferenceScopedResource(this.scopedThreadLocal, AtomicLong::new);
        sr.preAcquire();
        Assert.assertNotNull((Object)sr.get());
        System.gc();
        Assert.assertNotNull((Object)sr.get());
        sr.close();
        System.gc();
        Assert.assertNull((Object)sr.get());
    }
}

