/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.shutdown;

import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.shutdown.Hooklet;
import org.junit.Assert;
import org.junit.Test;

public class HookletTest {
    @Test
    public void testOnShutdown() {
        final AtomicBoolean called = new AtomicBoolean(false);
        Hooklet hooklet = new Hooklet(){

            public void onShutdown() {
                called.set(true);
            }

            public int priority() {
                return 0;
            }
        };
        hooklet.onShutdown();
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void testPriority() {
        Hooklet hooklet = new Hooklet(){

            public void onShutdown() {
            }

            public int priority() {
                return 10;
            }
        };
        Assert.assertEquals((long)10L, (long)hooklet.priority());
    }

    @Test
    public void testOf() {
        AtomicBoolean called = new AtomicBoolean(false);
        Runnable hook = () -> called.set(true);
        Hooklet hooklet = Hooklet.of((int)20, (Runnable)hook);
        Assert.assertEquals((long)20L, (long)hooklet.priority());
        hooklet.onShutdown();
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void testCompareTo() {
        Hooklet hooklet2;
        Hooklet hooklet1 = Hooklet.of((int)10, () -> {});
        Assert.assertTrue((hooklet1.compareTo(hooklet2 = Hooklet.of((int)20, () -> {})) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsAndHashCode() {
        TestRunnable runnable = new TestRunnable();
        Hooklet hooklet1 = Hooklet.of((int)10, (Runnable)runnable);
        Hooklet hooklet2 = Hooklet.of((int)10, (Runnable)runnable);
        Assert.assertEquals((Object)hooklet1, (Object)hooklet2);
        Assert.assertEquals((long)hooklet1.hashCode(), (long)hooklet2.hashCode());
    }

    @Test
    public void testToString() {
        Hooklet hooklet = Hooklet.of((int)10, () -> {});
        String toStringResult = hooklet.toString();
        Assert.assertTrue((boolean)toStringResult.startsWith("Hooklet{ priority: 10, identity: "));
        Assert.assertTrue((boolean)toStringResult.contains("HookletTest"));
    }

    static class TestRunnable
    implements Runnable {
        TestRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

