/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.function.Supplier;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CleaningThreadLocalTest {
    @Test
    public void testConstructor() {
        Supplier<String> supplier = () -> "test";
        ThrowingConsumer cleanup = value -> {};
        CleaningThreadLocal ctl = new CleaningThreadLocal(supplier, cleanup);
        Assertions.assertNotNull((Object)ctl);
    }

    @Test
    public void testWithCloseQuietly() {
        Supplier<String> supplier = () -> "test";
        CleaningThreadLocal ctl = CleaningThreadLocal.withCloseQuietly(supplier);
        Assertions.assertNotNull((Object)ctl);
    }

    @Test
    public void testResourceCleanup() {
        Runnable cleanupAction = (Runnable)Mockito.mock(Runnable.class);
        CleaningThreadLocal ctl = CleaningThreadLocal.withCleanup(() -> cleanupAction, Runnable::run);
        Thread thread = new Thread(() -> {
            ctl.set((Object)cleanupAction);
            ctl.remove();
        });
        thread.start();
        this.joinThread(thread);
        ((Runnable)Mockito.verify((Object)cleanupAction)).run();
    }

    @Test
    public void testThreadSafety() throws InterruptedException {
        Supplier<String> supplier = () -> "test";
        ThrowingConsumer cleanup = value -> {};
        CleaningThreadLocal ctl = new CleaningThreadLocal(supplier, cleanup);
        Thread t1 = new Thread(() -> ctl.set((Object)"Thread 1"));
        Thread t2 = new Thread(() -> ctl.set((Object)"Thread 2"));
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    @Test
    public void testExceptionInCleanup() {
        Supplier<String> supplier = () -> "test";
        ThrowingConsumer cleanup = value -> {
            throw new RuntimeException("Cleanup failed");
        };
        CleaningThreadLocal ctl = new CleaningThreadLocal(supplier, cleanup);
    }

    @Test
    public void testThreadSpecificValue() {
        CleaningThreadLocal ctl = CleaningThreadLocal.withCleanup(() -> 0, value -> {});
        Thread thread1 = new Thread(() -> ctl.set((Object)1));
        Thread thread2 = new Thread(() -> ctl.set((Object)2));
        thread1.start();
        thread2.start();
        this.joinThread(thread1);
        this.joinThread(thread2);
        ctl.remove();
        Assertions.assertEquals((int)0, (Integer)((Integer)ctl.get()));
    }

    private void joinThread(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

