/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.ThreadDump;
import org.junit.Assume;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ThreadDumpTest {
    private ThreadDump threadDump;

    @BeforeEach
    void setUp() {
        this.threadDump = new ThreadDump();
    }

    @Test
    public void testIgnoreThread() {
        String ignoredThreadName = "IgnoredThread";
        this.threadDump.ignore(ignoredThreadName);
        Thread ignoredThread = new Thread(() -> {}, ignoredThreadName);
        ignoredThread.start();
        this.threadDump.assertNoNewThreads();
        ignoredThread.interrupt();
    }

    @Test
    void testAssertNoNewThreads() {
        this.threadDump.assertNoNewThreads();
    }

    @Test
    void testAssertNewThreads() {
        Assume.assumeFalse((boolean)Jvm.isArm());
        Thread newThread = new Thread(() -> Jvm.pause((long)10000L));
        newThread.start();
        Jvm.pause((long)100L);
        Assertions.assertThrows(AssertionError.class, () -> ((ThreadDump)this.threadDump).assertNoNewThreads(), (String)("newThread.isAlive()= " + newThread.isAlive()));
        newThread.interrupt();
    }
}

