/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.PosixTimeProvider;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.testframework.FlakyTestRunner;
import net.openhft.posix.ClockId;
import net.openhft.posix.PosixAPI;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PosixTimeProviderTest
extends CoreTestCommon {
    static void assertBetween(long min, long actual, long max) {
        if (min <= actual && actual <= max) {
            return;
        }
        throw new AssertionError((Object)("Not in range " + min + " <= " + actual + " <= " + max));
    }

    public static void main(String[] args) {
        for (ClockId value : ClockId.values()) {
            System.out.println(value + " " + PosixAPI.posix().clock_gettime(value));
        }
    }

    @Test
    public void currentTimeMicros() throws IllegalStateException {
        Assume.assumeFalse((OS.isMacOSX() || Jvm.isArm() ? 1 : 0) != 0);
        FlakyTestRunner.builder(this::currentTimeMicros0).withMaxIterations(3).build().runOrThrow();
    }

    public void currentTimeMicros0() {
        @NotNull PosixTimeProvider tp = PosixTimeProvider.INSTANCE;
        long minDiff = 0L;
        long maxDiff = 0L;
        int error = OS.isWindows() || Jvm.isArm() ? 12 : 1;
        for (int i = 0; i <= 20; ++i) {
            minDiff = 10L;
            maxDiff = 995L;
            long lastTimeMicros = 0L;
            long start = System.currentTimeMillis();
            do {
                long now0 = tp.currentTimeMillis();
                long time2 = tp.currentTimeMicros();
                long now1 = tp.currentTimeMillis();
                if (now1 - now0 > 1L) {
                    System.out.println("jump: " + (now1 - now0));
                    continue;
                }
                long now = now1 * 1000L;
                long diff = time2 - now;
                if (minDiff > diff) {
                    minDiff = diff;
                    System.out.println("min: " + minDiff);
                }
                if (maxDiff < diff) {
                    maxDiff = diff;
                    System.out.println("max: " + maxDiff);
                }
                long ns = System.nanoTime();
                while (System.nanoTime() < ns + 100L) {
                    Jvm.nanoPause();
                }
                Assert.assertTrue((time2 >= lastTimeMicros ? 1 : 0) != 0);
                lastTimeMicros = time2;
            } while (System.currentTimeMillis() < start + 500L);
            try {
                if (!OS.isWindows()) {
                    PosixTimeProviderTest.assertBetween(-5 * error, minDiff, 5 * error);
                }
                PosixTimeProviderTest.assertBetween(990L, maxDiff, 1000 + 30 * error);
                break;
            }
            catch (AssertionError assertionError) {
                continue;
            }
        }
        if (!OS.isWindows()) {
            PosixTimeProviderTest.assertBetween(-5 * error, minDiff, 5 * error);
        }
        PosixTimeProviderTest.assertBetween(990L, maxDiff, 1000 + 30 * error);
    }

    @Test
    public void currentTime() throws IllegalStateException {
        Assume.assumeTrue((!OS.isMacOSX() ? 1 : 0) != 0);
        PosixTimeProvider tp = PosixTimeProvider.INSTANCE;
        for (int i = 3; i >= 0; --i) {
            long time2 = tp.currentTimeMillis();
            long time3 = tp.currentTimeMicros();
            long time4 = tp.currentTimeNanos();
            try {
                PosixTimeProviderTest.assertBetween(time3 / 1000L - 1L, time2, time3 / 1000L + 20L);
                PosixTimeProviderTest.assertBetween(time4 / 1000L - 100L, time3, time4 / 1000L + 2000L);
                continue;
            }
            catch (AssertionError ae) {
                Thread.yield();
                if (i != 0) continue;
                throw ae;
            }
        }
    }

    @Test
    public void resolution() {
        Assume.assumeTrue((!OS.isMacOSX() ? 1 : 0) != 0);
        PosixTimeProvider instance = PosixTimeProvider.INSTANCE;
        for (int j = 0; j < 3; ++j) {
            Histogram h = new Histogram(32, 10, 1.0);
            long last = instance.currentTimeNanos();
            for (int i = 0; i < 5000000; ++i) {
                long next = instance.currentTimeNanos();
                h.sampleNanos(next - last);
                Jvm.nanoPause();
                last = next;
            }
            System.out.println(h.toMicrosFormat());
            Assert.assertTrue((h.totalCount() > 0L ? 1 : 0) != 0);
        }
    }
}

