/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import net.openhft.chronicle.core.util.Builder;
import net.openhft.chronicle.core.util.MyClass;
import net.openhft.chronicle.core.util.MyClassBuilder;
import net.openhft.chronicle.core.util.OneTimeUseMyClassBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BuilderTest {
    BuilderTest() {
    }

    @Test
    void buildShouldReturnNonNullInstance() {
        MyClassBuilder builder = new MyClassBuilder();
        MyClass instance = (MyClass)builder.build();
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    void buildShouldReturnNewInstanceForMutableTypes() {
        MyClassBuilder builder = new MyClassBuilder();
        MyClass firstInstance = (MyClass)builder.build();
        MyClass secondInstance = (MyClass)builder.build();
        Assertions.assertNotSame((Object)firstInstance, (Object)secondInstance);
    }

    @Test
    void buildShouldThrowExceptionIfInvokedMultipleTimesWhenNotAllowed() {
        OneTimeUseMyClassBuilder oneTimeUseBuilder = new OneTimeUseMyClassBuilder();
        oneTimeUseBuilder.build();
        Assertions.assertThrows(IllegalStateException.class, () -> ((Builder)oneTimeUseBuilder).build());
    }

    @Test
    void getShouldDelegateToBuild() {
        MyClassBuilder builder = new MyClassBuilder();
        MyClass instanceFromGet = (MyClass)builder.get();
        MyClass instanceFromBuild = (MyClass)builder.build();
    }
}

