/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import net.openhft.chronicle.core.util.LongBiPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LongBiPredicateTest {
    LongBiPredicateTest() {
    }

    @Test
    void testShouldReturnCorrectResult() {
        LongBiPredicate predicate = (t, u) -> t > u;
        Assertions.assertTrue((boolean)predicate.test(3L, 2L));
        Assertions.assertFalse((boolean)predicate.test(2L, 3L));
    }

    @Test
    void andShouldCombineTwoPredicates() {
        LongBiPredicate predicate1 = (t, u) -> t > u;
        LongBiPredicate predicate2 = (t, u) -> t % 2L == 0L;
        LongBiPredicate combined = predicate1.and(predicate2);
        Assertions.assertTrue((boolean)combined.test(4L, 3L));
        Assertions.assertFalse((boolean)combined.test(3L, 2L));
    }

    @Test
    void negateShouldInvertPredicate() {
        LongBiPredicate predicate = (t, u) -> t > u;
        LongBiPredicate negated = predicate.negate();
        Assertions.assertFalse((boolean)negated.test(3L, 2L));
        Assertions.assertTrue((boolean)negated.test(2L, 3L));
    }

    @Test
    void orShouldCombineTwoPredicates() {
        LongBiPredicate predicate1 = (t, u) -> t > u;
        LongBiPredicate predicate2 = (t, u) -> u > 2L;
        LongBiPredicate combined = predicate1.or(predicate2);
        Assertions.assertTrue((boolean)combined.test(1L, 3L));
        Assertions.assertFalse((boolean)combined.test(2L, 2L));
    }
}

