/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.pool.Ecn;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.junit.Assert;
import org.junit.Test;

public class ObjectUtilsTest
extends CoreTestCommon {
    @Test
    public void testImmutable() {
        for (Class c : new Class[]{String.class, Integer.class, Date.class, BigDecimal.class, ZonedDateTime.class}) {
            Assert.assertEquals((String)c.getName(), (Object)ObjectUtils.Immutability.MAYBE, (Object)ObjectUtils.isImmutable((Class)c));
        }
        for (Class c : new Class[]{ArrayList.class, HashMap.class}) {
            Assert.assertEquals((String)c.getName(), (Object)ObjectUtils.Immutability.NO, (Object)ObjectUtils.isImmutable((Class)c));
        }
    }

    @Test
    public void canConvertTo() {
        Assert.assertTrue((boolean)ObjectUtils.canConvertText(String.class));
        Assert.assertTrue((boolean)ObjectUtils.canConvertText(Class.class));
        Assert.assertTrue((boolean)ObjectUtils.canConvertText(Boolean.class));
        Assert.assertTrue((boolean)ObjectUtils.canConvertText(UUID.class));
        Assert.assertTrue((boolean)ObjectUtils.canConvertText(byte[].class));
        Assert.assertTrue((boolean)ObjectUtils.canConvertText(Ecn.class));
        Assert.assertTrue((boolean)ObjectUtils.canConvertText(Long.class));
        Assert.assertTrue((boolean)ObjectUtils.canConvertText(ClassWithString.class));
        Assert.assertTrue((boolean)ObjectUtils.canConvertText(ClassWithValueOf.class));
        Assert.assertTrue((boolean)ObjectUtils.canConvertText(ClassWithParse.class));
        Assert.assertFalse((boolean)ObjectUtils.canConvertText(ClassWithSetter.class));
    }

    @Test
    public void testConvert() throws IllegalStateException, IllegalArgumentException {
        Assert.assertEquals((long)49L, (long)((Character)ObjectUtils.convertTo(Character.TYPE, (Object)1)).charValue());
        Assert.assertEquals((long)49L, (long)((Character)ObjectUtils.convertTo(Character.TYPE, (Object)1L)).charValue());
        Assert.assertEquals((long)1L, (long)((Integer)ObjectUtils.convertTo(Integer.TYPE, (Object)Character.valueOf('1'))).intValue());
        Assert.assertEquals((long)1L, (long)((Long)ObjectUtils.convertTo(Long.TYPE, (Object)Character.valueOf('1'))));
        Assert.assertEquals((double)1.0, (double)((Double)ObjectUtils.convertTo(Double.TYPE, (Object)Character.valueOf('1'))), (double)0.0);
    }

    @Test
    public void testNoDefaultClassForInterfaceNewInstanceThrows() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            ExceptionHandler cfr_ignored_0 = (ExceptionHandler)ObjectUtils.newInstance(ExceptionHandler.class);
        });
    }

    @Test
    public void supplierForClassShouldHandleDifferentClassTypes() {
        Supplier regularClassSupplier = ObjectUtils.supplierForClass(RegularClass.class);
        Assert.assertNotNull(regularClassSupplier.get());
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ObjectUtils.supplierForClass(Integer.TYPE).get();
        });
    }

    @Test
    public void immutableShouldRegisterImmutability() {
        Class<RegularClass> testClass = RegularClass.class;
        ObjectUtils.immutable(testClass, (boolean)true);
    }

    @Test
    public void caseIgnoreLookupShouldCreateCorrectMap() {
        Map map = ObjectUtils.caseIgnoreLookup(MyEnum.class);
    }

    @Test
    public void valueOfIgnoreCaseShouldReturnCorrectEnum() {
        Enum result = ObjectUtils.valueOfIgnoreCase(MyEnum.class, (String)"my_value");
        Assert.assertEquals((Object)((Object)MyEnum.MY_VALUE), (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void supplierForInternalPackageTest() {
        Supplier supplier = ObjectUtils.supplierForInternalPackage();
        supplier.get();
    }

    @Test
    public void supplierForEnumTest() {
        Supplier supplier = ObjectUtils.supplierForEnum(MyEnum.class);
        Assert.assertNotNull(supplier.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void supplierForAbstractClassTest() {
        Supplier supplier = ObjectUtils.supplierForAbstractClass(AbstractTestClass.class);
        supplier.get();
    }

    @Test
    public void convertCharSingleCharacterTest() {
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)ObjectUtils.convertChar((Object)"a"));
    }

    @Test
    public void convertCharLongStringTest() {
        Assert.assertNull((Object)ObjectUtils.convertChar((Object)"long"));
    }

    @Test
    public void convertTo0SameClassTest() {
        String testString = "test";
        Assert.assertEquals((Object)testString, (Object)ObjectUtils.convertTo0(String.class, (Object)testString));
    }

    @Test
    public void convertTo0NullTest() {
        Assert.assertNull((Object)ObjectUtils.convertTo0(String.class, null));
    }

    @Test
    public void convertTo0VoidClassTest() {
        Assert.assertNull((Object)ObjectUtils.convertTo0(Void.class, (Object)"anyValue"));
    }

    @Test
    public void convertTo0ToStringTest() {
        Object testObject = new Object();
        Assert.assertEquals((Object)testObject.toString(), (Object)ObjectUtils.convertTo0(String.class, (Object)testObject));
    }

    @Test
    public void convertTo0ToNumberTest() {
        Assert.assertEquals((Object)10, (Object)ObjectUtils.convertTo0(Integer.class, (Object)"10"));
    }

    @Test
    public void convertTo0ToCharacterTest() {
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)ObjectUtils.convertTo0(Character.class, (Object)"a"));
    }

    @Test
    public void convertTo0ToCharSequenceUsingParserTest() {
        Assert.assertEquals((Object)"test", (Object)ObjectUtils.convertTo0(String.class, (Object)"test"));
    }

    @Test
    public void convertTo0ToDateFromLongTest() {
        long time = System.currentTimeMillis();
        Date expectedDate = new Date(time);
        Assert.assertEquals((Object)expectedDate, (Object)ObjectUtils.convertTo0(Date.class, (Object)time));
    }

    @Test(expected=ClassCastException.class)
    public void convertTo0UnsupportedConversionTest() {
        ObjectUtils.convertTo0(Map.class, (Object)"test");
    }

    @Test
    public void asCCETest() {
        Exception exception = new Exception("Test exception");
        ClassCastException cce = ObjectUtils.asCCE((Exception)exception);
        Assert.assertEquals((Object)exception, (Object)cce.getCause());
    }

    @Test
    public void sizeOfMapTest() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 1);
        map.put(2, 2);
        Assert.assertEquals((long)2L, (long)ObjectUtils.sizeOf(map));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void sizeOfUnsupportedTypeTest() {
        ObjectUtils.sizeOf((Object)new Object());
    }

    @Test
    public void convertToNumberTest() {
        Assert.assertEquals((Object)1, (Object)ObjectUtils.convertToNumber(Integer.class, (Object)"1"));
    }

    @Test
    public void newInstanceWithClassNameTest() {
        RegularClass instance = (RegularClass)ObjectUtils.newInstance((String)RegularClass.class.getName());
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void newInstanceOrNullValidClassTest() {
        RegularClass instance = (RegularClass)ObjectUtils.newInstanceOrNull(RegularClass.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void addAllTest() {
        Object[] result = (Integer[])ObjectUtils.addAll((Object)1, (Object[])new Integer[]{2, 3});
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])result);
    }

    @Test
    public void addAllSingleElementTest() {
        Object[] result = (Integer[])ObjectUtils.addAll((Object)1, (Object[])new Integer[0]);
        Assert.assertArrayEquals((Object[])new Integer[]{1}, (Object[])result);
    }

    @Test
    public void getAllInterfacesTest() {
        Class[] interfaces = ObjectUtils.getAllInterfaces((Object)new ImplementingClass());
    }

    @Test
    public void getAllInterfacesClassTest() {
        Class[] interfaces = ObjectUtils.getAllInterfaces(ImplementingClass.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAllInterfacesWithNullAccumulatorTest() {
        ObjectUtils.getAllInterfaces((Object)new ImplementingClass(), null);
    }

    @Test
    public void implementationToUseNonInterfaceTest() {
        Class impl = ObjectUtils.implementationToUse(RegularClass.class);
        Assert.assertEquals(RegularClass.class, (Object)impl);
    }

    public class RegularClass {
    }

    public class AbstractTestClass {
    }

    public class ImplementingClass {
    }

    static enum MyEnum {
        MY_VALUE;

    }

    static class ClassWithSetter {
        private String s;

        ClassWithSetter() {
        }

        public void setS(String s) {
            this.s = s;
        }
    }

    static class ClassWithParse {
        private final String s;

        public ClassWithParse(String s) {
            this.s = s;
        }

        public static ClassWithParse parse(CharSequence s) {
            return new ClassWithParse(s.toString());
        }
    }

    static class ClassWithValueOf {
        private final String s;

        public ClassWithValueOf(String s) {
            this.s = s;
        }

        public static ClassWithValueOf valueOf(String s) {
            return new ClassWithValueOf(s);
        }
    }

    static class ClassWithString {
        private final String s;

        public ClassWithString(String s) {
            this.s = s;
        }
    }
}

