/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.io.Serializable;
import net.openhft.chronicle.core.util.ReadResolvable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ReadResolvableTest {
    ReadResolvableTest() {
    }

    @Test
    void readResolveMethodInImplementingClassShouldReturnReplacementObject() {
        ReadResolvableImpl original = new ReadResolvableImpl();
        ReadResolvableImpl replacement = original.readResolve();
        Assertions.assertNotNull((Object)replacement);
        Assertions.assertNotSame((Object)original, (Object)replacement);
    }

    @Test
    void staticReadResolveShouldCallReadResolveForReadResolvableObjects() {
        ReadResolvableImpl original = new ReadResolvableImpl();
        ReadResolvableImpl resolved = (ReadResolvableImpl)ReadResolvable.readResolve((Object)original);
        Assertions.assertNotNull((Object)resolved);
        Assertions.assertNotSame((Object)original, (Object)resolved);
    }

    @Test
    void staticReadResolveShouldReturnSameObjectForSerializableNonReadResolvableObjects() {
        SerializableObject serializableObject = new SerializableObject();
        SerializableObject resolved = (SerializableObject)ReadResolvable.readResolve((Object)serializableObject);
        Assertions.assertSame((Object)serializableObject, (Object)resolved);
    }

    @Test
    void staticReadResolveShouldReturnSameObjectForNonSerializableNonReadResolvableObjects() {
        NonSerializableObject nonSerializableObject = new NonSerializableObject();
        NonSerializableObject resolved = (NonSerializableObject)ReadResolvable.readResolve((Object)nonSerializableObject);
        Assertions.assertSame((Object)nonSerializableObject, (Object)resolved);
    }

    static class NonSerializableObject {
        NonSerializableObject() {
        }
    }

    static class SerializableObject
    implements Serializable {
        SerializableObject() {
        }
    }

    static class ReadResolvableImpl
    implements ReadResolvable<ReadResolvableImpl> {
        ReadResolvableImpl() {
        }

        public ReadResolvableImpl readResolve() {
            return new ReadResolvableImpl();
        }
    }
}

