/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.BiFunction;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest
extends CoreTestCommon {
    @Test
    public void testIsEqualWithStringBuilderAndCharSequence() {
        StringBuilder sb = new StringBuilder("test");
        String cs = "test";
        Assert.assertTrue((boolean)StringUtils.isEqual((StringBuilder)sb, (CharSequence)cs));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)sb, (CharSequence)"different"));
    }

    @Test
    public void testSetLengthOfStringBuilder() {
        StringBuilder sb = new StringBuilder("test");
        StringUtils.setLength((StringBuilder)sb, (int)2);
        Assert.assertEquals((Object)"te", (Object)sb.toString());
    }

    @Test
    public void testSetStringBuilderContent() {
        StringBuilder sb = new StringBuilder("original");
        StringUtils.set((StringBuilder)sb, (CharSequence)"updated");
        Assert.assertEquals((Object)"updated", (Object)sb.toString());
    }

    @Test
    public void testEndsWith() {
        String cs = "testString";
        Assert.assertTrue((boolean)StringUtils.endsWith((CharSequence)cs, (String)"String"));
        Assert.assertTrue((boolean)StringUtils.endsWith((CharSequence)cs, (String)"string"));
    }

    @Test
    public void testStartsWith() {
        String cs = "testString";
        Assert.assertTrue((boolean)StringUtils.startsWith((CharSequence)cs, (String)"test"));
        Assert.assertFalse((boolean)StringUtils.startsWith((CharSequence)cs, (String)"String"));
    }

    @Test
    public void testIsEqualWithCharSequences() {
        String cs1 = "test";
        String cs2 = "test";
        String cs3 = "different";
        Assert.assertTrue((boolean)StringUtils.isEqual((CharSequence)cs1, (CharSequence)cs2));
        Assert.assertFalse((boolean)StringUtils.isEqual((CharSequence)cs1, (CharSequence)cs3));
    }

    @Test
    public void testEqualsCaseIgnore() {
        String cs1 = "TestString";
        String cs2 = "teststring";
        Assert.assertTrue((boolean)StringUtils.equalsCaseIgnore((CharSequence)cs1, (CharSequence)cs2));
        Assert.assertFalse((boolean)StringUtils.equalsCaseIgnore((CharSequence)cs1, (CharSequence)"AnotherString"));
    }

    @Test
    public void testToStringMethod() {
        String obj = "test";
        Assert.assertNull((Object)StringUtils.toString(null));
        Assert.assertEquals((Object)"test", (Object)StringUtils.toString((Object)obj));
    }

    @Test
    public void testExtractBytesString() {
        String str = "test";
        byte[] expectedBytes = str.getBytes(StandardCharsets.ISO_8859_1);
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])StringUtils.extractBytes((String)str));
    }

    @Test
    public void testNewStringFromChars() {
        char[] chars = new char[]{'t', 'e', 's', 't'};
        Assert.assertEquals((Object)"test", (Object)StringUtils.newString((char[])chars));
    }

    @Test
    public void testNewStringFromBytes() {
        byte[] bytes = "test".getBytes(StandardCharsets.ISO_8859_1);
        Assert.assertEquals((Object)"test", (Object)StringUtils.newStringFromBytes((byte[])bytes));
    }

    @Test
    public void testFirstLowerCase() {
        Assert.assertEquals((Object)"", (Object)StringUtils.firstLowerCase((String)""));
        Assert.assertEquals((Object)"99", (Object)StringUtils.firstLowerCase((String)"99"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.firstLowerCase((String)"A"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.firstLowerCase((String)"a"));
        Assert.assertEquals((Object)"aA", (Object)StringUtils.firstLowerCase((String)"AA"));
        Assert.assertEquals((Object)"aa", (Object)StringUtils.firstLowerCase((String)"Aa"));
    }

    @Test
    public void testToTitleCase() {
        Assert.assertEquals((Object)"", (Object)StringUtils.toTitleCase((String)""));
        Assert.assertEquals((Object)"99", (Object)StringUtils.toTitleCase((String)"99"));
        Assert.assertEquals((Object)"A", (Object)StringUtils.toTitleCase((String)"A"));
        Assert.assertEquals((Object)"A", (Object)StringUtils.toTitleCase((String)"a"));
        Assert.assertEquals((Object)"AA", (Object)StringUtils.toTitleCase((String)"AA"));
        Assert.assertEquals((Object)"AA", (Object)StringUtils.toTitleCase((String)"Aa"));
        Assert.assertEquals((Object)"AAA", (Object)StringUtils.toTitleCase((String)"AAA"));
        Assert.assertEquals((Object)"AA_A", (Object)StringUtils.toTitleCase((String)"AaA"));
        Assert.assertEquals((Object)"A_AA", (Object)StringUtils.toTitleCase((String)"AAa"));
        Assert.assertEquals((Object)"AAA", (Object)StringUtils.toTitleCase((String)"Aaa"));
        Assert.assertEquals((Object)"AAAA", (Object)StringUtils.toTitleCase((String)"AAAA"));
        Assert.assertEquals((Object)"AA_AA", (Object)StringUtils.toTitleCase((String)"AaAA"));
        Assert.assertEquals((Object)"A_AA_A", (Object)StringUtils.toTitleCase((String)"AAaA"));
        Assert.assertEquals((Object)"AAA_A", (Object)StringUtils.toTitleCase((String)"AaaA"));
        Assert.assertEquals((Object)"AA_AA", (Object)StringUtils.toTitleCase((String)"AAAa"));
        Assert.assertEquals((Object)"AA_AA", (Object)StringUtils.toTitleCase((String)"AaAa"));
        Assert.assertEquals((Object)"A_AAA", (Object)StringUtils.toTitleCase((String)"AAaa"));
        Assert.assertEquals((Object)"AAAA", (Object)StringUtils.toTitleCase((String)"Aaaa"));
    }

    @Test
    public void shouldGetCharsOfStringBuilder() {
        StringBuilder sb = new StringBuilder(11).append("foobar_nine");
        char[] chars = StringUtils.extractChars((StringBuilder)sb);
        Assert.assertEquals((Object)sb.toString(), (Object)new String(chars));
    }

    @Test
    public void shouldGetCharsOfString() {
        String s = "foobar_nine";
        char[] chars = StringUtils.extractChars((String)"foobar_nine");
        Assert.assertEquals((Object)"foobar_nine", (Object)new String(chars));
    }

    @Test
    public void shouldExtractBytesFromString() {
        Assert.assertTrue((boolean)Arrays.equals("foobar".getBytes(StandardCharsets.US_ASCII), StringUtils.extractBytes((String)"foobar")));
    }

    @Test
    public void shouldExtractBytesFromStringBuilder() {
        Assert.assertEquals((long)-2338138987911860342L, (long)Maths.hash64((StringBuilder)new StringBuilder("foobar")));
    }

    @Test
    public void shouldCreateNewStringFromChars() {
        char[] chars = new char[]{'A', 'B', 'C'};
        Assert.assertEquals((Object)new String(chars), (Object)StringUtils.newString((char[])chars));
    }

    @Test
    public void shouldCreateNewStringFromBytes() {
        byte[] bytes = new byte[]{65, 66, 67};
        String expected = new String(bytes, StandardCharsets.ISO_8859_1);
        String actual = StringUtils.newStringFromBytes((byte[])bytes);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseDouble() {
        for (double d : new double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, -1.0, 1.0, 9999.0}) {
            Assert.assertEquals((double)d, (double)StringUtils.parseDouble((CharSequence)Double.toString(d)), (double)0.0);
        }
        Assert.assertEquals((double)1.0, (double)StringUtils.parseDouble((CharSequence)"1"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)StringUtils.parseDouble((CharSequence)"-0"), (double)0.0);
        Assert.assertEquals((double)123.0, (double)StringUtils.parseDouble((CharSequence)"123"), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)StringUtils.parseDouble((CharSequence)"-1"), (double)0.0);
    }

    @Test
    public void testParseInt() {
        StringUtilsTest.validate((s, integer) -> StringUtils.parseInt((CharSequence)s, (int)integer));
    }

    @Test
    public void testParseLong() {
        StringUtilsTest.validate(StringUtils::parseLong);
    }

    private static void validate(BiFunction<String, Integer, Long> method) {
        Assert.assertEquals((long)100L, (long)method.apply("100", 10));
        Assert.assertEquals((long)-100L, (long)method.apply("-100", 10));
        NumberFormatException firstCharEx = (NumberFormatException)Assert.assertThrows(NumberFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)method.apply("+", 10);
        });
        Assert.assertEquals((Object)"For input string: \"+\"", (Object)firstCharEx.getMessage());
        NumberFormatException nullEx = (NumberFormatException)Assert.assertThrows(NumberFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)method.apply(null, 0);
        });
        Assert.assertEquals((Object)"null", (Object)nullEx.getMessage());
        NumberFormatException maxRadixEx = (NumberFormatException)Assert.assertThrows(NumberFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)method.apply("100", 37);
        });
        Assert.assertEquals((Object)"radix 37 greater than Character.MAX_RADIX", (Object)maxRadixEx.getMessage());
        NumberFormatException minRadixEx = (NumberFormatException)Assert.assertThrows(NumberFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)method.apply("100", 0);
        });
        Assert.assertEquals((Object)"radix 0 less than Character.MIN_RADIX", (Object)minRadixEx.getMessage());
    }

    @Test
    public void reverse() {
        StringBuilder stringBuilder = new StringBuilder("test");
        StringUtils.reverse((StringBuilder)stringBuilder, (int)0);
        Assert.assertEquals((Object)"tset", (Object)stringBuilder.toString());
    }

    @Test
    public void equalsCaseIgnore_equals() {
        Assert.assertTrue((boolean)StringUtils.equalsCaseIgnore((CharSequence)"aaa", (CharSequence)"AAA"));
        Assert.assertFalse((boolean)StringUtils.equalsCaseIgnore((CharSequence)"aaa", (CharSequence)"AAAA"));
        Assert.assertFalse((boolean)StringUtils.equalsCaseIgnore((CharSequence)"aaa", (CharSequence)"AA_"));
    }

    @Test
    public void startsWith_isValidPrefix() {
        Assert.assertTrue((boolean)StringUtils.startsWith((CharSequence)"abcd", (String)"ab"));
        Assert.assertFalse((boolean)StringUtils.startsWith((CharSequence)"abcd", (String)"abe"));
    }

    @Test
    public void startsWith_searchStringTooLong() {
        Assert.assertFalse((boolean)StringUtils.startsWith((CharSequence)"a", (String)"ab"));
    }

    @Test
    public void endsWith_isValidSuffix() {
        Assert.assertTrue((boolean)StringUtils.endsWith((CharSequence)"abcd", (String)"cd"));
        Assert.assertFalse((boolean)StringUtils.endsWith((CharSequence)"abcd", (String)"ed"));
    }

    @Test
    public void endsWith_searchStringIsTooLong() {
        Assert.assertFalse((boolean)StringUtils.endsWith((CharSequence)"abcd", (String)"aaabcd"));
    }

    @Test
    public void testIsEqual() {
        StringBuilder emptySb = new StringBuilder();
        Assert.assertTrue((boolean)StringUtils.isEqual((StringBuilder)emptySb, (CharSequence)emptySb));
        Assert.assertTrue((boolean)StringUtils.isEqual(null, null));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)emptySb, null));
        Assert.assertFalse((boolean)StringUtils.isEqual(null, (CharSequence)emptySb));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder(), (CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("a"), (CharSequence)"b"));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("test"), (CharSequence)"Test"));
        Assert.assertTrue((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("TheSame"), (CharSequence)"TheSame"));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("\u0394"), (CharSequence)"\u0393"));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("\u0394\u0394\u0394\u0394\u0394"), (CharSequence)"\u0394\u0394\u20ac\u0394\u0394"));
        Assert.assertTrue((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("\u0394\u0394\u0394\u0394\u0394"), (CharSequence)"\u0394\u0394\u0394\u0394\u0394"));
        Assert.assertTrue((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder(), (CharSequence)""));
    }
}

