/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.openhft.chronicle.core.util.ThreadConfinementAsserter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ThreadConfinementAsserterTest {
    ThreadConfinementAsserterTest() {
    }

    @Test
    void assertThreadConfinedSameThread() {
        ThreadConfinementAsserter asserter = ThreadConfinementAsserter.createEnabled();
        Assertions.assertDoesNotThrow(() -> ((ThreadConfinementAsserter)asserter).assertThreadConfined());
        Assertions.assertDoesNotThrow(() -> ((ThreadConfinementAsserter)asserter).assertThreadConfined());
    }

    @Test
    void assertThreadConfinedDifferentThreads() throws InterruptedException {
        ThreadConfinementAsserter asserter = ThreadConfinementAsserter.createEnabled();
        CountDownLatch latch = new CountDownLatch(1);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Assertions.assertDoesNotThrow(() -> ((ThreadConfinementAsserter)asserter).assertThreadConfined());
        executorService.execute(() -> {
            Assertions.assertThrows(IllegalStateException.class, () -> ((ThreadConfinementAsserter)asserter).assertThreadConfined());
            latch.countDown();
        });
        latch.await();
        executorService.shutdown();
    }

    @Test
    void createShouldReturnCorrectTypeBasedOnAssertions() {
        ThreadConfinementAsserter asserter = ThreadConfinementAsserter.create();
    }

    @Test
    void createEnabledShouldAlwaysReturnFunctionalAsserter() {
        ThreadConfinementAsserter asserter = ThreadConfinementAsserter.createEnabled();
        Assertions.assertNotNull((Object)asserter);
    }
}

