/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.core.pool.EnumCache;
import org.jetbrains.annotations.Nullable;

public class StaticEnumClass<E extends Enum<E>>
extends EnumCache<E> {
    private final E[] values;

    StaticEnumClass(Class<E> eClass) {
        super(eClass);
        this.values = (Enum[])eClass.getEnumConstants();
    }

    @Override
    @Nullable
    public E valueOf(String name) {
        return name == null || name.isEmpty() ? null : (E)Enum.valueOf(this.type, name);
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public E forIndex(int index) {
        return this.values[index];
    }

    @Override
    public E[] asArray() {
        return this.values;
    }

    @Override
    public <T> Map<E, T> createMap() {
        return new EnumMap(this.type);
    }

    @Override
    public Set<E> createSet() {
        return EnumSet.noneOf(this.type);
    }
}

