/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.engine.api.column.ClosableIterator;
import net.openhft.chronicle.engine.api.column.Column;
import net.openhft.chronicle.engine.api.column.ColumnView;
import net.openhft.chronicle.engine.api.column.ColumnViewInternal;
import net.openhft.chronicle.engine.api.column.Row;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.collection.RemoteColumnViewRowIterator;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.query.Filter;
import net.openhft.chronicle.network.connection.AbstractStatelessClient;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteColumnView
extends AbstractStatelessClient
implements ColumnView {
    @NotNull
    private final Asset asset;
    private final ThreadLocal<List> th = ThreadLocal.withInitial(ArrayList::new);
    private final Function<ValueIn, RemoteColumnViewRowIterator> readIteratorProxy = v -> {
        WireIn wireIn = v.wireIn();
        return (RemoteColumnViewRowIterator)wireIn.read("set-proxy").applyToMarshallable(wire -> new RemoteColumnViewRowIterator(this.hub, wire.read((WireKey)CoreFields.csp).text(), wire.read((WireKey)CoreFields.cid).int64()));
    };

    public RemoteColumnView(@NotNull RequestContext context, @NotNull Asset asset) {
        super(asset.findView(TcpChannelHub.class), 0L, RemoteColumnView.toURL(context));
        this.asset = asset;
    }

    @NotNull
    private static String toURL(@NotNull RequestContext context) {
        return context.viewType(ColumnView.class).toUri();
    }

    @Override
    @NotNull
    public Asset asset() {
        return this.asset;
    }

    @Override
    @Nullable
    public List<Column> columns() {
        List l = this.th.get();
        l.clear();
        return (List)this.proxyReturnWireTypedObject(EventId.columns, this.th, List.class, new Object[0]);
    }

    @Override
    public int rowCount(@NotNull ColumnViewInternal.SortedFilter sortedFilter) {
        int count = this.proxyReturnInt(EventId.rowCount, new Object[]{sortedFilter});
        return count;
    }

    @Override
    public int changedRow(@NotNull Map<String, Object> row, @NotNull Map<String, Object> oldRow) {
        return this.proxyReturnInt(EventId.changedRow, new Object[]{row, oldRow});
    }

    @Override
    public void registerChangeListener(@NotNull Runnable r) {
        RequestContext rc = RequestContext.requestContext().fullName(this.asset.fullName());
        this.asset.acquireView(ObjectSubscription.class).registerSubscriber(rc, o -> r.run(), Filter.empty());
    }

    @Override
    @NotNull
    public ClosableIterator<? extends Row> iterator(@NotNull ColumnViewInternal.SortedFilter sortedFilter) {
        return (RemoteColumnViewRowIterator)this.proxyReturnWireConsumerInOut((WireKey)EventId.iterator, (WireKey)CoreFields.reply, valueOut -> valueOut.marshallable((WriteMarshallable)sortedFilter), this.readIteratorProxy);
    }

    @Override
    public boolean canDeleteRows() {
        return this.proxyReturnBoolean((WireKey)EventId.canDeleteRows);
    }

    @Override
    public boolean containsRowWithKey(List keys) {
        return (Boolean)this.proxyReturnWireTypedObject(EventId.containsRowWithKey, null, Boolean.class, new Object[]{keys});
    }

    @Override
    @Nullable
    public ObjectSubscription objectSubscription() {
        return this.asset.getView(ObjectSubscription.class);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        columns(new WireKey[0]),
        rowCount((WireKey[])new Params[]{Params.sortedFilter}),
        changedRow((WireKey[])new Params[]{Params.row, Params.oldRow}),
        canDeleteRows(new WireKey[0]),
        containsRowWithKey((WireKey[])new Params[]{Params.keys}),
        iterator((WireKey[])new Params[]{Params.sortedFilter});

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    public static enum Params implements WireKey
    {
        sortedFilter,
        row,
        oldRow,
        keys;

    }
}

