/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.column;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.openhft.chronicle.engine.api.column.Column;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class Row
extends AbstractMarshallable {
    private List<String> columnNames;
    @NotNull
    private Map<String, Object> data = new LinkedHashMap<String, Object>();

    public Row() {
    }

    public Row(@NotNull List<Column> columns) {
        this.columnNames = columns.stream().map(c -> c.name).collect(Collectors.toList());
    }

    public Object get(String columnName) {
        return this.data.get(columnName);
    }

    public Object get(int columnIndex) {
        return this.data.get(this.columnNames.get(columnIndex));
    }

    @NotNull
    public <R> R copyTo(@NotNull R using) {
        Wires.copyTo(this.data, using);
        return using;
    }

    public void set(String columnName, Object newValue) {
        assert (this.columnNames.contains(columnName));
        this.data.put(columnName, newValue);
    }
}

