/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.management.mbean;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetTreeDynamicMBean
implements DynamicMBean {
    @NotNull
    private final Properties properties = new Properties();
    private final Map attributeList;

    public AssetTreeDynamicMBean(Map attributeList) {
        this.attributeList = attributeList;
        this.load();
    }

    @Override
    public synchronized String getAttribute(@NotNull String name) throws AttributeNotFoundException {
        String value = this.properties.getProperty(name);
        if (value != null) {
            return value;
        }
        throw new AttributeNotFoundException("No such property: " + name);
    }

    @Override
    public synchronized void setAttribute(@NotNull Attribute attribute) throws InvalidAttributeValueException, MBeanException, AttributeNotFoundException {
        String name = attribute.getName();
        if (this.properties.getProperty(name) == null) {
            throw new AttributeNotFoundException(name);
        }
        Object value = attribute.getValue();
        if (!(value instanceof String)) {
            throw new InvalidAttributeValueException("Attribute value not a string: " + value);
        }
        this.properties.setProperty(name, (String)value);
    }

    public void setAttribute(@NotNull String name, String value) {
        Attribute attribute = new Attribute(name, value);
        AttributeList list = new AttributeList();
        list.add(attribute);
        this.setAttributes(list);
    }

    @Override
    @NotNull
    public synchronized AttributeList getAttributes(@NotNull String[] names) {
        AttributeList list = new AttributeList();
        for (String name : names) {
            String value = this.properties.getProperty(name);
            if (value == null) continue;
            list.add(new Attribute(name, value));
        }
        return list;
    }

    @Override
    @NotNull
    public synchronized AttributeList setAttributes(@NotNull AttributeList list) {
        Attribute[] attrs = list.toArray(new Attribute[0]);
        AttributeList retlist = new AttributeList();
        for (Attribute attr : attrs) {
            String name = attr.getName();
            Object value = attr.getValue();
            if (!(value instanceof String)) continue;
            this.properties.setProperty(name, (String)value);
            retlist.add(new Attribute(name, value));
        }
        return retlist;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull String name, @Nullable Object[] args, @Nullable String[] sig) throws MBeanException, ReflectionException {
        if (!(!name.equals("reload") || args != null && args.length != 0 || sig != null && sig.length != 0)) {
            this.load();
            return null;
        }
        throw new ReflectionException(new NoSuchMethodException(name));
    }

    @Override
    @Nullable
    public synchronized MBeanInfo getMBeanInfo() {
        TreeSet<Object> names = new TreeSet<Object>();
        for (Object name : this.properties.keySet()) {
            names.add(name);
        }
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[names.size()];
        Iterator it = names.iterator();
        for (int i = 0; i < attrs.length; ++i) {
            String name = (String)it.next();
            attrs[i] = new MBeanAttributeInfo(name, "java.lang.String", "Property " + name, true, true, false);
        }
        MBeanOperationInfo[] opers = new MBeanOperationInfo[]{new MBeanOperationInfo("reload", "Reload properties from file", null, "void", 1)};
        return new MBeanInfo(this.getClass().getName(), "Property Manager MBean", attrs, null, opers, null);
    }

    private void load() {
        this.properties.putAll((Map<?, ?>)this.attributeList);
    }
}

