/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.query;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.engine.api.query.TypeToString;
import net.openhft.chronicle.wire.Marshallable;
import org.jetbrains.annotations.NotNull;

public class GenericTypesToString
implements TypeToString {
    private final Map<String, Class> cache1 = new ConcurrentHashMap<String, Class>();
    private final Map<Class, String> cache2 = new ConcurrentHashMap<Class, String>();

    public GenericTypesToString(Class ... clazzes) {
        for (Class clazz : clazzes) {
            for (Method m : clazz.getMethods()) {
                if (Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 1) continue;
                Class<?> c = m.getParameterTypes()[0];
                Class<?> old = this.cache1.put(m.getName().intern(), c);
                if (old != null) {
                    throw new IllegalStateException("name=" + m.getName() + " is alread assosiated with " + old + ", you cant re-assosisiate it with " + c.getSimpleName());
                }
                String oldName = this.cache2.put(c, m.getName());
                if (oldName == null) continue;
                throw new IllegalStateException("name=" + c.getSimpleName() + " is alread assosiated with " + oldName + ", you cant re-assosisiate it with " + m.getName());
            }
        }
    }

    @Override
    public String typeToString(Class type) {
        return this.cache2.get(type);
    }

    @Override
    public Class<? extends Marshallable> toType(@NotNull CharSequence type) {
        return this.cache1.get(type.toString());
    }
}

