/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.tree;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiPredicate;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionCollection;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.AssetTreeStats;
import net.openhft.chronicle.engine.api.tree.LeafViewFactory;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.WrappingViewFactory;
import net.openhft.chronicle.engine.map.KVSSubscription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Asset
extends Closeable {
    public String name();

    @Nullable
    public Asset parent();

    @NotNull
    default public String fullName() {
        Asset parent = this.parent();
        return parent == null ? "/" : (parent.parent() == null ? "/" + this.name() : parent.fullName() + "/" + this.name());
    }

    @Nullable
    public SubscriptionCollection subscription(boolean var1) throws AssetNotFoundException;

    @Nullable
    default public Asset getAsset(@NotNull String fullName) {
        if (fullName.isEmpty()) {
            return this;
        }
        int pos = fullName.indexOf("/");
        if (pos == 0) {
            fullName = fullName.substring(1);
            pos = fullName.indexOf("/");
        }
        if (pos >= 0) {
            String name1 = fullName.substring(0, pos);
            String name2 = fullName.substring(pos + 1);
            Asset asset = this.getChild(name1);
            if (asset == null) {
                return null;
            }
            return asset.getAsset(name2);
        }
        return this.getChild(fullName);
    }

    @NotNull
    public Asset acquireAsset(String var1) throws AssetNotFoundException;

    @Nullable
    default public Asset findAsset(@NotNull String name) {
        Asset asset = this.getAsset(name);
        Asset parent = this.parent();
        if (asset == null && parent != null) {
            asset = parent.findAsset(name);
        }
        return asset;
    }

    @Nullable
    default public <V> V findView(@NotNull Class<V> viewType) {
        V v = this.getView(viewType);
        Asset parent = this.parent();
        if (v == null && parent != null) {
            v = parent.findView(viewType);
        }
        return v;
    }

    @Nullable
    default public <V> V findOrCreateView(@NotNull Class<V> viewType) throws AssetNotFoundException {
        V v = this.getView(viewType);
        if (v == null) {
            if (this.hasFactoryFor(viewType)) {
                return this.acquireView(viewType);
            }
            Asset parent = this.parent();
            if (parent != null) {
                v = parent.findOrCreateView(viewType);
            }
        }
        return v;
    }

    public <V> boolean hasFactoryFor(Class<V> var1);

    public Asset getChild(String var1);

    public void removeChild(String var1);

    @NotNull
    default public <V> V acquireView(@NotNull RequestContext requestContext) throws AssetNotFoundException {
        return this.acquireView(requestContext.viewType(), requestContext);
    }

    @NotNull
    public <V> V acquireView(Class<V> var1, RequestContext var2) throws AssetNotFoundException;

    @NotNull
    default public <V> V acquireView(Class<V> viewType) {
        return this.acquireView(viewType, RequestContext.requestContext(this.fullName()));
    }

    @Nullable
    public <V> V getView(Class<V> var1);

    public <V> void registerView(Class<V> var1, V var2);

    public <V> void addLeafRule(Class<V> var1, String var2, LeafViewFactory<V> var3);

    public <V, U> void addWrappingRule(Class<V> var1, String var2, WrappingViewFactory<V, U> var3, Class<U> var4);

    public <V, U> void addWrappingRule(Class<V> var1, String var2, BiPredicate<RequestContext, Asset> var3, WrappingViewFactory<V, U> var4, Class<U> var5);

    public String dumpRules();

    public <V> V addView(Class<V> var1, V var2);

    default public <V> V addView(@NotNull V view) {
        return (V)this.addView(view.getClass(), view);
    }

    public boolean isSubAsset();

    @NotNull
    default public Asset root() {
        Asset parent = this.parent();
        return parent == null ? this : parent.root();
    }

    public boolean hasChildren();

    public <T extends Throwable> void forEachChild(ThrowingConsumer<Asset, T> var1) throws T;

    public void getUsageStats(AssetTreeStats var1);

    default public <E> void unregisterSubscriber(@NotNull RequestContext requestContext, @NotNull Subscriber<Object> subscriber) {
        Class<SubscriptionCollection> subscriptionType = requestContext.getSubscriptionType();
        SubscriptionCollection subscription = this.getView(subscriptionType);
        if (subscription == null) {
            subscriber.onEndOfSubscription();
        } else {
            subscription.unregisterSubscriber(subscriber);
        }
    }

    default public <T, E> void unregisterTopicSubscriber(@NotNull RequestContext requestContext, @NotNull TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        SubscriptionCollection subscription = this.getView(requestContext.getSubscriptionType());
        if (subscription instanceof KVSSubscription) {
            ((KVSSubscription)subscription).unregisterTopicSubscriber(subscriber);
        } else {
            subscriber.onEndOfSubscription();
        }
    }

    default public <T, E> void unregisterTopicSubscriber(@NotNull String uri, @NotNull Class<T> topicClass, @NotNull Class<E> messageClass, @NotNull TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(uri).keyType(topicClass).valueType(messageClass);
        SubscriptionCollection subscription = this.getView(rc.getSubscriptionType());
        if (subscription instanceof KVSSubscription) {
            ((KVSSubscription)subscription).unregisterTopicSubscriber(subscriber);
        } else {
            subscriber.onEndOfSubscription();
        }
    }

    default public <T, E> void registerTopicSubscriber(@NotNull String uri, @NotNull Class<T> topicClass, @NotNull Class<E> messageClass, @NotNull TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(uri).keyType(topicClass).valueType(messageClass);
        SubscriptionCollection subscriptionCollection = this.acquireSubscription(rc);
        KVSSubscription kvsSubscription = (KVSSubscription)subscriptionCollection;
        kvsSubscription.registerTopicSubscriber(rc, subscriber);
    }

    @NotNull
    default public SubscriptionCollection acquireSubscription(@NotNull RequestContext requestContext) {
        Class<SubscriptionCollection> subscriptionType = requestContext.getSubscriptionType();
        requestContext.viewType(subscriptionType);
        return this.acquireView(subscriptionType, requestContext);
    }

    default public Set<Class> viewTypes() {
        return Collections.emptySet();
    }

    @NotNull
    default public <K, V> MapView<K, V> acquireMap(@NotNull String uri, Class<K> kClass, Class<V> vClass) throws AssetNotFoundException {
        RequestContext requestContext = RequestContext.requestContext(uri);
        if (requestContext.bootstrap() != null) {
            throw new UnsupportedOperationException("Its not possible to set the bootstrap when acquiring a map");
        }
        return (MapView)this.acquireView(requestContext.view("map").type(kClass).type2(vClass));
    }
}

