/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.cfg;

import java.io.IOException;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.cfg.Installable;
import net.openhft.chronicle.engine.map.ChronicleMapKeyValueStore;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronicleMapCfg
implements Installable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChronicleMapCfg.class);
    private Class keyType;
    private Class valueType;
    private boolean putReturnsNull;
    private boolean removeReturnsNull;
    private String compression;
    private String diskPath;
    private long entries = -1L;
    private double averageSize = -1.0;

    @Override
    @Nullable
    public Void install(@NotNull String path, @NotNull AssetTree assetTree) throws IOException {
        Asset asset = assetTree.acquireAsset(path);
        ((VanillaAsset)asset).enableTranslatingValuesToBytesStore();
        RequestContext rc = RequestContext.requestContext(path);
        rc.basePath(this.diskPath).putReturnsNull(this.putReturnsNull).removeReturnsNull(this.removeReturnsNull);
        if (this.entries != -1L) {
            rc.entries(this.entries);
        }
        if (this.averageSize != -1.0) {
            rc.averageValueSize(this.averageSize);
        }
        ChronicleMapKeyValueStore chronicleMapKeyValueStore = new ChronicleMapKeyValueStore(rc, asset);
        asset.addView(ObjectKeyValueStore.class, chronicleMapKeyValueStore);
        return null;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read(() -> "diskPath").text((Object)this, (o, c) -> {
            o.diskPath = c;
        }).read(() -> "keyType").typeLiteral((Object)this, (o, c) -> {
            o.keyType = c;
        }).read(() -> "valueType").typeLiteral((Object)this, (o, c) -> {
            o.valueType = c;
        }).read(() -> "compression").text((Object)this, (o, c) -> {
            o.compression = c;
        }).read(() -> "putReturnsNull").bool((Object)this, (o, e) -> {
            o.putReturnsNull = e;
        }).read(() -> "removeReturnsNull").bool((Object)this, (o, e) -> {
            o.removeReturnsNull = e;
        }).read(() -> "entries").int64((Object)this, (o, e) -> {
            o.entries = e;
        }).read(() -> "averageSize").float64((Object)this, (o, e) -> {
            o.averageSize = e;
        });
    }

    @NotNull
    public String toString() {
        return "ChronicleMapCfg{keyType=" + this.keyType + ", valueType=" + this.valueType + ", putReturnsNull=" + this.putReturnsNull + ", removeReturnsNull=" + this.removeReturnsNull + ", compression='" + this.compression + '\'' + '}';
    }
}

